/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyServicePackagePubServiceImpl.java   2021-01-14 11-52-43
 * Author: Evan
 */
package com.xforceplus.business.messagebus.impl;

import com.xforceplus.api.model.CompanyServiceRelModel;
import com.xforceplus.business.messagebus.CompanyServicePackagePubService;
import com.xforceplus.business.messagebus.bus.MessageBusAsyncService;
import com.xforceplus.business.pub.service.PubSubAsyncService;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.ServicePackage;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.web.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * <p>
 * Title: 公司服务包绑定关系消息发布服务
 * </p>
 * <p>
 * Description: 公司服务包绑定关系（发布到MQ）
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-01-14 11-52-43
 * @since V1.0
 */
@Slf4j
@Service
public class CompanyServicePackagePubServiceImpl implements CompanyServicePackagePubService {


    private final MessageBusAsyncService messageBusAsyncService;

    @Resource
    private PubSubAsyncService pubSubAsyncService;

    public CompanyServicePackagePubServiceImpl(MessageBusAsyncService messageBusAsyncService) {
        this.messageBusAsyncService = messageBusAsyncService;
    }

    @Value("${xforce.pub.companyService:xforce.tenant.companyService}")
    private String companyServicePubCode;

    @Value("${xforce.pub.companyService.v1:tenant_company_service}")
    private String companyServicePubCodeV1;


    @Override
    public void sendMessage(String channelId, CompanyServiceRelModel.Response.TenantModel tenantModel,
                            List<CompanyServiceRelModel.Response.CompanyServiceModel> companyServiceModels) {
        if (null == messageBusAsyncService) {
            log.info("pubsub.enable=false,messageBusService={}", messageBusAsyncService);
            return;
        }

        Map<String, String> tagkvs = new HashMap<>();
        tagkvs.put("requestName", companyServicePubCode);
        tagkvs.put("channelId", channelId);
        //businessNo为业务流水号， !=空&&<64
        tagkvs.put("businessNo", tenantModel.getTenantId().toString());
        tagkvs.put("tenantId", tenantModel.getTenantId().toString());

        Map<String, Object> contentMap = new HashMap<>();
        contentMap.put("tenant", tenantModel);
        contentMap.put("companyServices", companyServiceModels);

        String content = JsonUtils.toJson(contentMap);
        log.debug("company.pub.content:{}", content);

        //pubv1
        pubSubAsyncService.sendMessage(companyServicePubCodeV1,tagkvs,content);

        //pubv2
        messageBusAsyncService.sendMessage(companyServicePubCode,tagkvs,content);
    }

    @Override
    public List<CompanyServiceRelModel.Response.CompanyServiceModel> buildCompanyServiceMessage(
            Map<Long, ServicePackage> servicePackageMap, Map<Long, Company> companyMap, Set<CompanyServiceRel> resl, String operation) {

        List<CompanyServiceRelModel.Response.CompanyServiceModel> pubModels = new ArrayList<>();
        for (CompanyServiceRel rel : resl) {
            CompanyServiceRelModel.Response.CompanyServiceModel model = new CompanyServiceRelModel.Response.CompanyServiceModel();
            model.setStatus(rel.getStatus());
            model.setId(rel.getId());
            model.setOperation(operation);
            CompanyServiceRelModel.Response.ServicePackageModel servicePackageModel = new CompanyServiceRelModel.Response.ServicePackageModel();
            ServicePackage servicePackage = servicePackageMap.get(rel.getServicePackageId());
            BeanUtils.copyProperties(servicePackage, servicePackageModel);
            model.setServicePackageModel(servicePackageModel);

            Company company = companyMap.get(rel.getCompanyId());
            CompanyServiceRelModel.Response.CompanyModel companyModel = new CompanyServiceRelModel.Response.CompanyModel();
            BeanUtils.copyProperties(company, companyModel);
            model.setCompanyModel(companyModel);
            pubModels.add(model);
        }
        return pubModels;
    }

}
