package com.xforceplus.business.messagebus.impl;

import com.xforceplus.business.messagebus.OrgPubService;
import com.xforceplus.business.messagebus.bus.MessageBusAsyncService;
import com.xforceplus.entity.OrgStruct;
import io.geewit.web.utils.JsonUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: duanhy
 * @date: 2021/10/29 11:51
 * @Description:
 */
@Service
@Log4j
@RequiredArgsConstructor
public class OrgPubServiceImpl implements OrgPubService {

    @Value("${xforce.pub.orgInfo:uc_org_info}")
    private String orgInfoTopic;

    private final MessageBusAsyncService messageBusAsyncService;

    @Override
    public void sendOrgMsg(String operation, OrgStruct orgStruct) {
        Map<String, String> tagkvs = new HashMap<>();
        tagkvs.put("requestName", orgInfoTopic);
        tagkvs.put("tenantId", String.valueOf(orgStruct.getTenantId()));
        tagkvs.put("businessNo", orgStruct.getOrgId() + "");

        Map<String, Object> map = new HashMap<>();
        map.put("tenantId", orgStruct.getTenantId());
        map.put("org", orgStruct);
        map.put("operation", operation);
        String content = JsonUtils.toJson(map);

        messageBusAsyncService.sendMessage(orgInfoTopic,tagkvs,content);
    }

}
