package com.xforceplus.business.messagebus.impl;

import com.xforceplus.business.messagebus.UserPubService;
import com.xforceplus.business.messagebus.bus.MessageBusAsyncService;
import com.xforceplus.business.pub.service.PubSubAsyncService;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import io.geewit.core.jackson.view.View;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.web.utils.JsonUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

/**
 * @author: duanhy
 * @date: 2021/10/29 10:50
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class UserPubServiceImpl implements UserPubService {

    private final MessageBusAsyncService messageBusAsyncService;
    private final PubSubAsyncService pubSubAsyncService;

    @Value("${xforce.pub.accountUserTenant:account_user_tenant}")
    private String accountUserTenant;

    @Value("${pub.sub.uc.push.user-pubsub:tenant.user.change.status}")
    private String userStatusPubSubCode;

    @Value("${pub.sub.uc.push.user-status:false}")
    private boolean pushUserStatus;

    @Override
    public void pub(User user, Account account, Tenant tenant) {

        User copyUser = new User();
        Account copyAccount = new Account();
        try {
            BeanUtils.copyProperties(user, copyUser, Stream.of("account", "tenant", "filteredOrgs", "hostCompanies").toArray(String[]::new));
            BeanUtils.copyProperties(account, copyAccount, Stream.of("salt", "password").toArray(String[]::new));
        } catch (Exception e) {
            log.error("send_account_user_tenant_error", e);
        }

        Map<String, String> tagkvs = new HashMap<>();
        tagkvs.put("requestName", accountUserTenant);
        tagkvs.put("businessNo", copyUser.getId()+"");
        tagkvs.put("tenantId", String.valueOf(tenant.getTenantId()));

        Map<String, Object> map = new HashMap<>();
        map.put("account", copyAccount);
        map.put("user", copyUser);
        map.put("tenant", tenant);

        try {
            String content = JsonUtils.toJson(map);
            messageBusAsyncService.sendMessage(accountUserTenant, tagkvs, content);
        } catch (Exception e) {
            log.error("send_account_user_tenant_error", e);
        }
    }


    @Override
    public void sendUserToPubsub(User existEntity, Long tenantId) {
        if (!pushUserStatus) {
            return ;
        }
        User user = new User();
        BeanUtils.copyProperties(existEntity, user, Stream.of("roleUserRels", "orgUserRels", "orgVirtualNodeUserRels", "userApps").toArray(String[]::new));
        Map<String, String> tagkvs = new HashMap<>();
        tagkvs.put("tenantId", tenantId.toString());
        tagkvs.put("id", user.getId().toString());
        tagkvs.put("status", user.getStatus().toString());
        tagkvs.put("businessNo", user.getId().toString());

        user.setTicketOpeningTerminal("");
        user.setPrintingEquipment("");
        user.setBusinessExtensionAttribute("");
        String content = JsonUtils.toJson(user, View.Info.class);

        //pubv1
        pubSubAsyncService.sendMessage(userStatusPubSubCode, tagkvs,content);

        //pubv2
        messageBusAsyncService.sendMessage(userStatusPubSubCode, tagkvs, content);
    }
}
