package com.xforceplus.business.messagebus.model;

import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author: duanhy
 * @date: 2021/11/26 11:12
 * @Description:
 */
public interface ZeusCompany {

    interface Model {

        @Getter
        @Setter
        class CompanyRelModel {
            private String operationType;
            private ZeusCompany.Model.CompanyModel company;
            private ZeusCompany.Model.RelModel rel;
        }

        @Getter
        @Setter
        class CompanyModel {
            private String businNum;
            private String businessId;
            private String checkListener;
            private String checkRemark;
            private String checkTime;
            private String checkUserId;
            private String chineseAddress;
            private String companyCode;
            private String companyName;
            private String companyNameAbbr;
            private String companyNameAbbrEn;
            private String companyNameEn;
            private String companyType;
            private String confirmFlag;
            private String confirmRemark;
            private String confirmTime;
            @SuppressWarnings("AlibabaLowerCamelCaseVariableNaming")
            private String contactorEMail;
            private String contactorName;
            private String contactorPhone;
            private String contactorTel;
            private String corpCode;
            private String corpFlag;
            private String countryNameAbbr;
            private String createTime;
            private String createUserId;
            private String defaultFlag;
            private String deleteTime;
            private String deleteUserId;
            private String domesticInstitutionCode;
            private String effectiveFlag;
            private String ext1;
            private String ext10;
            private String ext2;
            private String ext3;
            private String ext4;
            private String ext5;
            private String ext6;
            private String ext7;
            private String ext8;
            private String ext9;
            private Long externalId;
            private String idCard;
            private String lockFlag;
            private String lockTime;
            private String openingType;
            private String orgCode;
            private String origTaxnum;
            private String overseasIdCard;
            private String recordFlag;
            private String remark;
            private String taxControl;
            private String taxNum;
            private Integer taxpayerType;
            private String updateTime;
            private String updateUserId;

            public void setCreateTime(String createTime) {
                if (StringUtils.isNotBlank(createTime)) {
                    this.createTime = createTime.substring(0, createTime.length() - 3);
                }
            }

            public void setUpdateTime(String updateTime) {
                if (StringUtils.isNotBlank(updateTime)) {
                    this.updateTime = updateTime.substring(0, updateTime.length() - 3);
                }
            }
        }

        @Getter
        @Setter
        class RelModel {
            private String companyCode;
            private String companyNo;
            private String createTime;
            private String createUserId;
            private Long externalId;
            private String inOutFlag;
            private String innerPurchaser;
            private String innerSeller;
            private String outerPurchaser;
            private String outerSeller;
            private Long relId;
            private String status;
            private Long tenantId;
            private String updateTime;
            private String updateUserId;
        }
    }
}
