package com.xforceplus.business.messagebus.model;

import com.xforceplus.entity.User;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author: duanhy
 * @date: 2021/11/26 11:12
 * @Description:
 */
public interface ZeusUser {


    interface Model {

        class Build {
            public static User buildUserEntity(User user, UserModel userModel) {
                user.setId(userModel.getExternalId());
                user.setUserEmailAddr(userModel.getEmail());
                if(StringUtils.isBlank(userModel.getGender())){
                    user.setUserSex(null);
                }else{
                    user.setUserSex("0".equals(userModel.getGender()) ? 1 :0);
                }
                user.setUserIdCard(userModel.getIdNumber());
                user.setUserPhone(userModel.getMobilePhone());
                user.setStatus(userModel.getStatus());
                user.setUserName(userModel.getUserName());
                return user;
            }
        }

        @Getter
        @Setter
        class UserAccountModel {
            private String operationType;
            private Long tenantId;
            private UserModel user;
            private AccountModel account;
        }

        @Getter
        @Setter
        class UserModel {
            private String createTime;
            private String createUserId;
            private String email;
            private Long externalId;
            private String gender;
            private String idNumber;
            private String mobilePhone;
            private Integer status;
            private String updateTime;
            private String updateUserId;
            private String userId;
            private String userName;
            public void setCreateTime(String createTime) {
                if (StringUtils.isNotBlank(createTime)) {
                    this.createTime = createTime.substring(0, createTime.length() - 3);
                }
            }

            public void setUpdateTime(String updateTime) {
                if (StringUtils.isNotBlank(updateTime)) {
                    this.updateTime = updateTime.substring(0, updateTime.length() - 3);
                }
            }
        }

        @Getter
        @Setter
        class AccountModel {
            private String accountId;
            private String accountName;
            private String createTime;
            private String createUserId;
            private String email;
            private String errorLoginCount;
            private String errorLoginDate;
            private Long externalId;
            private String lastLoginDate;
            private String lastLoginIp;
            private String loginVerifyExprieDate;
            private String mobile;
            private String password;
            private String pwdExpireDate;
            private String regeditType;
            private String salt;
            private String secretKey;
            private String status;
            private String type;
            private String updateTime;
            private String updateUserId;
            private String userId;
            private String validateCode;
            private String validateExprieDate;
            private String validateType;

            public void setCreateTime(String createTime) {
                if (StringUtils.isNotBlank(createTime)) {
                    this.createTime = createTime.substring(0, createTime.length() - 3);
                }
            }

            public void setUpdateTime(String updateTime) {
                if (StringUtils.isNotBlank(updateTime)) {
                    this.updateTime = updateTime.substring(0, updateTime.length() - 3);
                }
            }
        }
    }
}
