/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelNoticeConfig.java   2020-09-27 10-42-42
 * Author: Evan
 */
package com.xforceplus.business.notice.dto;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * Title: 消息配置
 * </p>
 * <p>
 * Description: Excel消息消息配置
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-27 10-42-42
 * @since V1.0
 */
public class ExcelNoticeConfig {
    /**
     * 全部成功导出的信息
     */
    public static final String EXP_SUCCESS = "EXP_SUCCESS";
    /**
     * 导出开始任务
     */
    public static final String EXP_START = "EXP_START";
    /**
     * 导出异常原因
     */
    public static final String EXP_EXCEPTION = "EXP_EXCEPTION";
    /**
     * 导出无数据提示消息
     */
    public static final String EXP_SUCCESS_NO_DATA = "EXP_SUCCESS_NO_DATA";
    /**
     * 导入异常原因
     */
    public static final String IMP_EXCEPTION = "IMP_EXCEPTION";
    /**
     * 导入开始
     */
    public static final String IMP_START = "IMP_START";
    /**
     * 全部成功导入
     */
    public static final String IMP_SUCCESS = "IMP_SUCCESS";
    /**
     * 导入部分成功
     */
    public static final String IMP_PART_SUCCESS = "IMP_PART_SUCCESS";
    /**
     * 导入全部失败
     */
    public static final String IMP_FAILED = "IMP_FAILED=";
    /**
     * Excel消息配置
     */
    private static final Map<String, NoticeTemplate> NOTICE_TEMPLATES = new HashMap<>();

    static {
        NOTICE_TEMPLATES.put(EXP_START, new NoticeTemplate("{0}正在导出", "{0}正在导出,稍后可自行下载，请您关注消息通知"));
        NOTICE_TEMPLATES.put(EXP_EXCEPTION, new NoticeTemplate("{0}导出失败", "{0}导出失败原因：{1}"));
        NOTICE_TEMPLATES.put(EXP_SUCCESS, new NoticeTemplate("{0}导出成功", "{0}导出成功。请点击<a href=\"{2}\">【{3}】</a>下载文件查看"));
        NOTICE_TEMPLATES.put(EXP_SUCCESS_NO_DATA, new NoticeTemplate("{0}导出无数据", "{0}导出无数据"));
        NOTICE_TEMPLATES.put(IMP_START, new NoticeTemplate("{0}正在导入", "{0}正在导入，请您关注消息通知"));
        NOTICE_TEMPLATES.put(IMP_EXCEPTION, new NoticeTemplate("{0}导入失败", "{0}导入失败原因：{1}"));
        NOTICE_TEMPLATES.put(IMP_FAILED, new NoticeTemplate("{0}导入全部失败", "{0}导入全部失败：总数{1}条数据,失败:{2}条数据,请点击<a href=\"{3}\">【{4}】</a>下载文件查看"));
        NOTICE_TEMPLATES.put(IMP_SUCCESS, new NoticeTemplate("{0}导入完成", "{0}导入成功,成功导入{1}条数据"));
        NOTICE_TEMPLATES.put(IMP_PART_SUCCESS, new NoticeTemplate("{0}导入部分成功", "{0}部分导入成功,总数:{1}条数据，成功导入{2}条数据。失败:{3}条数据,请点击<a href=\"{4}\">【{5}】</a>下载文件查看"));
    }

    /**
     * 获取模板消息
     *
     * @param key key
     * @return NoticeTemplate
     */
    public static NoticeTemplate getTemplate(String key) {
        if (NOTICE_TEMPLATES.containsKey(key)) {
            return NOTICE_TEMPLATES.get(key);
        }
        throw new IllegalArgumentException("消息模板不正确");
    }
}
