/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: NoticeTemplate.java   2020-09-27 09-54-36
 * Author: Evan
 */
package com.xforceplus.business.notice.dto;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * <p>
 * Title: 消息通知模板
 * </p>
 * <p>
 * Description: 消息通知模板
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-27 09-54-36
 * @since V1.0
 */
@Getter
@Setter
@ToString
public class NoticeTemplate implements Serializable {

    /**
     * 消息标题模板
     */
    private String title;
    /**
     * 消息内容模板
     */
    private String content;

    /**
     * 消息处理
     * @param title 消息模板标题
     * @param content 消息模板内容
     */
    public NoticeTemplate(String title, String content) {
        this.title = title;
        this.content = content;
    }
}
