package com.xforceplus.business.notice.entity;


import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;


@Getter
@Builder
@ToString
/**
 * @author HWT
 * @date 2020/9/23  10:59
 **/
public class ExcelProcessNotice {

    @ApiModelProperty("tenantId")
    @NotNull(message = "tenantId不能为空")
    long tenantId;

    @ApiModelProperty("发送人id, 当scope=[GLOBAL,APP_GLOBAL]时必填")
    @NotNull(message = "用戶UID")
    private Long senderId;

    @ApiModelProperty("消息标题")
    @NotBlank(message = "标题必须非空")
    @Size(min = 1, max = 128, message = "标题字符超过限制")
    private String title;

    @ApiModelProperty("消息内容")
    @Size(max = 2500, message = "内容字符超过限制")
    private String content;

    @ApiModelProperty("标签")
    private List<String> tags;

    @ApiModelProperty("附件下载链接")
    @Size(max = 2048)
    private String url;
}
