package com.xforceplus.business.notice.service;


import com.xforcecloud.noification.model.*;
import com.xforceplus.business.excel.ExcelConfig;
import com.xforceplus.business.notice.entity.ExcelProcessNotice;
import com.xforceplus.feign.tenant.message.MessageClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


/**
 * @author HWT
 * @date 2020/9/23  11:00
 **/
@Service
@Slf4j
public class NoticeService {

    /**
     * 1 业务消息
     */
    private static final Integer MESSAGE_TYPE = 1;
    /**
     * 响应
     */
    private static final String SUCCESS_CODE = "MSGCZZ0000";
    @Autowired
    private MessageClient messageClient;

    public void sendExcelProcessNotice(ExcelProcessNotice excelProcessNotice) {
        log.info("sendExcelProcessNotice:{}", excelProcessNotice);
        MessageInfo messageInfo = new MessageInfo();
        BeanUtils.copyProperties(excelProcessNotice, messageInfo);
        messageInfo.setScope(Scope.SINGLE);
        messageInfo.setType(MESSAGE_TYPE);
        List<Long> receiverList = new ArrayList<>();
        receiverList.add(excelProcessNotice.getSenderId());
        messageInfo.setReceiverIds(receiverList);

        BaseResponse response = messageClient.sendMessage(ExcelConfig.getAppId(), excelProcessNotice.getTenantId(), messageInfo);
        if (response != null && SUCCESS_CODE.equals(response.getCode())) {
            log.info("sendExcelProcessNotice_success, response:{}", response);
        } else {
            log.error("sendExcelProcessNotice_exception,  response：{}", response);
            throw new IllegalArgumentException("SendNoticeError");
        }
    }

    public BaseResponse getMessage(Long tenantId) {
        QueryType queryType = QueryType.SINGLE;
        int pageNo = 1;
        int pageSize = 10;
        BaseResponse<MessagePage> baseResponse = messageClient.queryMessages(ExcelConfig.getAppId(), tenantId, queryType, null, null, pageNo, pageSize);
        log.debug("getMessage:{}", baseResponse);
        return baseResponse;
    }

}
