package com.xforceplus.business.org.virtual.controller;

import static com.xforceplus.api.current.org.virtual.OrgVirtualOrgStructRelApi.Path.BATCH_EXPORT;
import static com.xforceplus.api.current.org.virtual.OrgVirtualOrgStructRelApi.Path.IMPORT;
import static com.xforceplus.business.excel.writer.ExcelConfigBusinessType.ORG_VIRTUAL_ORG_STRUCT_CONFIG_EXCEL_FILE;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.current.org.virtual.OrgVirtualOrgStructRelApi;
import com.xforceplus.api.model.OrgVirtualOrgStructRelModel.Request;
import com.xforceplus.api.model.OrgVirtualOrgStructRelModel.Request.Query;
import com.xforceplus.api.model.OrgVirtualOrgStructRelModel.Request.Relate;
import com.xforceplus.business.common.controller.AbstractController;
import com.xforceplus.business.excel.ExcelFile;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.org.virtual.service.OrgVirtualOrgStructService;
import com.xforceplus.domain.orgVirtual.OrgVirtualOrgStructDTO;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.OrgVirtualOrgStructRel;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

/**
 * @author zhouxin
 * @copyright © 上海云砺信息科技有限公司
 * @date 2021/8/4 13:56
 */
@Api(value = "虚拟组织行政组织关联控制器")
@Controller
@Slf4j
@SuppressWarnings("all")
public class OrgVirtualOrgStructRelController extends AbstractController implements OrgVirtualOrgStructRelApi, com.xforceplus.api.tenant.org.virtual.OrgVirtualOrgStructRelApi {

    @Autowired
    private OrgVirtualOrgStructService orgVirtualOrgStructService;

    @Autowired
    private ExportFileService exportFileService;

    @Autowired
    private ImportFileService importFileService;

    @ResponseBody
    @AuthorizedDefinition(resources = {"xforce:ucenter:org-virtual:org:save"})
    @ApiOperation(value = "业务组织关联行政组织批量导出excel", notes = "业务组织关联行政组织批量导出excel")
    @RequestMapping(name = "业务组织关联行政组织批量导出excel", value = BATCH_EXPORT, method = RequestMethod.POST)
    public ResponseEntity<ImportFileRespVo> batchExportBind(@ApiParam(value = "request") @RequestBody Request.ExcelExportQuery query) {
        if (ArrayUtils.isEmpty(query.getSheets())) {
            throw new IllegalArgumentException("请选择SheetName");
        }
        //异步执行
        QueryParam queryParam = QueryParam.builder()
                .param(ExcelFile.PARAMS_QUERY, query)
                .build();
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), ORG_VIRTUAL_ORG_STRUCT_CONFIG_EXCEL_FILE);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(ORG_VIRTUAL_ORG_STRUCT_CONFIG_EXCEL_FILE.getBusinessName());
        //检查ExcelFile文件是否正确
        return ResponseEntity.ok(respVo);
    }

    @AuthorizedDefinition(resources = {"xforce:ucenter:org-virtual:org:save"})
    @ApiOperation(value = "业务组织关联行政组织批量导入excel")
    @ResponseBody
    @RequestMapping(name = "业务组织关联行政组织批量导入excel", value = IMPORT, produces = {"application/json"}, method = RequestMethod.POST)
    public ResponseEntity<ImportFileRespVo> batchImportBind(@RequestParam("file") MultipartFile file) {
        IAuthorizedUser currentUser = UserInfoHolder.currentUser();
        Long tenantId = currentUser.getTenantId();
        Long userId = currentUser.getId();

        String businessType = ORG_VIRTUAL_ORG_STRUCT_CONFIG_EXCEL_FILE.name();
        //保存数据和上传文件，并转为异步处理
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, businessType, userId, tenantId);

        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(businessType);
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        //检查ExcelFile文件是否正确
        return ResponseEntity.ok(respVo);
    }

    @Override
    @AuthorizedDefinition(resources = {"xforce:ucenter:org-virtual:org:read"})
    @ApiOperation(value = "当前租户下业务组织关联的行政组织分页查询")
    public ResponseEntity<Page<OrgVirtualOrgStructRel>> page(Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort(pageable, Sort.by(Sort.Direction.DESC, "createTime"));
        query.setTenantId(UserInfoHolder.currentUser().getTenantId());
        Page<OrgVirtualOrgStructRel> page = orgVirtualOrgStructService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @Override
    @AuthorizedDefinition(resources = {"xforce:ucenter:org-virtual:org:save"})
    @ApiOperation(value = "当前租户下业务组织增加行政组织关联")
    public ResponseEntity<Boolean> relate(@RequestBody Relate model) {
        model.setTenantId(UserInfoHolder.currentUser().getTenantId());
        return ResponseEntity.ok(orgVirtualOrgStructService.relate(model));
    }

    @Override
    @AuthorizedDefinition(resources = {"xforce:ucenter:org-virtual:org:read"})
    @ApiOperation(value = "指定租户下业务组织关联的行政组织分页查询")
    public ResponseEntity<Page<OrgVirtualOrgStructRel>> page(@PathVariable("tenantKey") String tenantKey,
                                                                           Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort(pageable, Sort.by(Sort.Direction.DESC, "createTime"));
        Long tenantId = super.toTenant(tenantKey).getTenantId();
        query.setTenantId(tenantId);
        Page<OrgVirtualOrgStructRel> page = orgVirtualOrgStructService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @Override
    @AuthorizedDefinition(resources = {"xforce:ucenter:org-virtual:org:save"})
    @ApiOperation(value = "指定租户下业务组织增加行政组织关联")
    public ResponseEntity<Boolean> relate(@PathVariable("tenantKey") String tenantKey,
                                          @RequestBody Relate model) {
        Long tenantId = super.toTenant(tenantKey).getTenantId();
        model.setTenantId(tenantId);
        return ResponseEntity.ok(orgVirtualOrgStructService.relate(model));
    }
}
