package com.xforceplus.business.org.virtual.dto;


import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.validation.constraints.StringInclude;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author dhy
 */
@Setter
@Getter
@ToString
public class OrgVirtualImportDto extends DataRow {

    @ExcelProperty(value = "操作")
    @StringInclude(message = "操作 应该为:{\"新建\",\"修改\"}", range = {"新建", "修改"})
    @NotBlank(message = "操作不能为空")
    private String action;

    @ExcelProperty(value = "业务组织代码")
    @NotBlank(message = "业务组织代码不能为空")
    private String orgCode;

    @ExcelProperty("业务组织名称")
    @NotBlank(message = "业务组织名称不能为空")
    private String orgName;

    @ExcelProperty("简称")
    private String shortName;

    @ExcelProperty("描述")
    private String orgDesc;

    @ExcelProperty("启用状态")
    @NotNull(message = "启用状态不能为空")
    private Integer status;

    @ExcelProperty("关联行政组织代码")
    private String orgStructCode;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = StringUtils.trim(orgCode);
    }

    public void setOrgName(String orgName) {
        this.orgName = StringUtils.trim(orgName);
    }

    public void setShortName(String shortName) {
        this.shortName = StringUtils.trim(shortName);
    }

    public void setOrgDesc(String orgDesc) {
        this.orgDesc = StringUtils.trim(orgDesc);
    }

    public void setOrgStructCode(String orgStructCode) {
        this.orgStructCode = StringUtils.trim(orgStructCode);
    }
}
