package com.xforceplus.business.org.virtual.dto;


import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.validation.constraints.StringInclude;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;

/**
 * @author dhy
 */
@Setter
@Getter
@ToString
public class OrgVirtualNodeImportDto extends DataRow {

    @ExcelProperty(value = "操作")
    @StringInclude(message = "操作 应该为:{\"新建\",\"修改\"}", range = {"新建", "删除"})
    @NotBlank(message = "操作不能为空")
    private String action;

    @ExcelProperty(value = "业务组织树代码")
    @NotBlank(message = "业务组织代码不能为空")
    private String orgCode;

    @ExcelProperty(value = "上级业务组织树代码")
    private String parentOrgCode;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = StringUtils.trim(orgCode);
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = StringUtils.trim(parentOrgCode);
    }
}
