package com.xforceplus.business.org.virtual.dto;


import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.validation.constraints.StringInclude;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;

/**
 * @author dhy
 */
@Setter
@Getter
@ToString
public class OrgVirtualNodeRelUserImportDto extends DataRow {

    @ExcelProperty(value = "操作")
    @StringInclude(message = "操作 应该为:{\"绑定\",\"解绑\"}", range = {"绑定", "解绑"})
    @NotBlank(message = "操作不能为空")
    private String action;

    @ExcelProperty(value = "业务组织树代码")
    @NotBlank(message = "业务组织代码不能为空")
    private String orgCode;

    @ExcelProperty(value = "账号")
    @NotBlank(message = "账号不能为空")
    private String username;

    @ExcelProperty(value = "管控下级")
    @StringInclude(message = "管控下级 应该为:{\"当前组织\",\"当前组织及下级组织\"}", range = {"当前组织", "当前组织及下级组织"})
    @NotBlank(message = "管控下级不能为空")
    private String controlFlag;


    @ExcelProperty(value = "管理员标识")
    /*
     * @StringInclude(message = "管理员标识 应该为:{\"否\",\"是\" }", range = {"0", "1"})
     */
    private String adminFlag;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = StringUtils.trim(orgCode);
    }

    public void setUsername(String username) {
        this.username = StringUtils.trim(username);
    }

    public void setControlFlag(String controlFlag) {
        this.controlFlag = StringUtils.trim(controlFlag);
    }

    public void setAdminFlag(String adminFlag) {
        this.adminFlag = StringUtils.trim(adminFlag);
    }
}
