package com.xforceplus.business.org.virtual.dto;


import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.validation.constraints.StringInclude;
import javax.validation.constraints.NotBlank;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

/**
* @copyright © 上海云砺信息科技有限公司
* @author zhouxin
* @date 2021/8/4 17:02
*/
@Setter
@Getter
@ToString
public class OrgVirtualOrgStructImportDto extends DataRow {

    @ExcelProperty(value = "操作")
    @StringInclude(message = "操作 应该为:{\"新增\",\"删除\"}", range = {"新增", "删除"})
    @NotBlank(message = "操作不能为空")
    private String action;

    @ExcelProperty(value = "业务组织代码")
    @NotBlank(message = "业务组织代码不能为空")
    private String orgVirtualCode;

    @ExcelProperty("行政组织代码")
    @NotBlank(message = "行政组织代码不能为空")
    private String orgStructCode;

    @ExcelProperty("行政组织名称")
    private String orgStructName;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setOrgVirtualCode(String orgVirtualCode) {
        this.orgVirtualCode = StringUtils.trim(orgVirtualCode);
    }

    public void setOrgStructCode(String orgStructCode) {
        this.orgStructCode = StringUtils.trim(orgStructCode);
    }

    public void setOrgStructName(String orgStructName) {
        this.orgStructName = StringUtils.trim(orgStructName);
    }
}
