package com.xforceplus.business.org.virtual.service;

import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import org.springframework.stereotype.Service;

import java.util.List;

import static com.xforceplus.business.excel.ExcelFile.PARAMS_QUERY;
import static com.xforceplus.business.org.virtual.service.OrgVirtualConfigExcel.SN_BUSINESS_CONFIG;

/**
 * 版权：    上海云砺信息科技有限公司
 * author:  duanhy
 * 创建时间: 2021/1/11 15:18
 * 功能描述:
 * 修改历史:
 */
@Service
public class OrgVirtualExcelExportServiceImpl implements ExcelWriteService {

    /**
     * 业务组织服务
     */
    private final OrgVirtualService orgVirtualService;

    public OrgVirtualExcelExportServiceImpl(OrgVirtualService orgVirtualService) {
        this.orgVirtualService = orgVirtualService;
    }

    /**
     * 获取导入类型，用于Event事件调整导入方法
     * @return ImportBusinessType
     */
    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_VIRTUAL_CONFIG_EXCEL_FILE;
    }

    /**
     * 导出公共方法
     *
     * @param context 上下文
     * @return Context
     */
    @Override
    public void write(Context context) {
        OrgVirtualModel.Request.ExcelExportQuery query = context.getParam(PARAMS_QUERY, OrgVirtualModel.Request.ExcelExportQuery.class);
        //租户Id
        Long tenantId = context.getFileDTO().getTenantId();
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        query.setTenantId(tenantId);
        for (String sheetName : query.getSheets()) {
            //业务组织
            if (SN_BUSINESS_CONFIG.equals(sheetName)) {
                List<OrgVirtualModel.Response.ExcelExportModel> list = this.orgVirtualService.listToExcel(query);
                simpleExcelWriter.fill(sheetName, list);
            }
        }
    }
}
