package com.xforceplus.business.org.virtual.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.org.virtual.dto.OrgVirtualImportDto;
import com.xforceplus.business.service.ExcelReaderService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * @author dhy
 */
@Service
public class OrgVirtualImportServiceImpl implements ExcelReaderService {
    public static final String ACTION_CREATE = "新建";
    public static final String ACTION_UPDATE = "修改";
    /**
     * 操作列表
     */
    public static final List<String> ACTION_LISTS = Arrays.asList(ACTION_CREATE, ACTION_UPDATE);
    /**
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(OrgVirtualImportServiceImpl.class);
    @Resource
    private OrgVirtualService orgVirtualService;

    /**
     * 获取导入类型，用于Event事件调整导入方法
     * @return ImportBusinessType
     */
    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_VIRTUAL_IMPORT;
    }

    /**
     * 异步导出处理
     *
     * @param context 上下文
     * @return Context
     */
    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            //构建监听器
            AnalysisEventListener<OrgVirtualImportDto> excelDataListener = SimpleDataReadListener.listener(context, (rows) -> {
                this.saveData(messageRows, context, rows);
            });
            //开始处理
            context.getSimpleExcelReader().read(OrgVirtualImportDto.class, excelDataListener);
        }
        return context;
    }

    /**
     * 写入数据
     *
     * @param list
     */
    public void saveData(MessageRow messageRows, Context context, List<OrgVirtualImportDto> list) {
        if (logger.isDebugEnabled()) {
            logger.debug("list:{}", JSON.toJSONString(list));
        }
        for (OrgVirtualImportDto dto : list) {
            if (logger.isDebugEnabled()) {
                logger.debug("dto:{}", JSON.toJSONString(dto));
            }
            String msg = orgVirtualService.importSave(dto, context.getFileDTO().getTenantId());
            if (StringUtils.isNoneBlank(msg)) {
                messageRows.fail(dto.getRowIndex(), msg);
            } else {
                messageRows.success(dto.getRowIndex());
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }
}
