package com.xforceplus.business.org.virtual.service;

import com.xforceplus.business.excel.BusinessAttribute;
import com.xforceplus.business.excel.ExcelSheet;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;


/**
 * 版权：    上海云砺信息科技有限公司
 * author:  duanhy
 * 创建时间: 2021/1/11 15:18
 * 功能描述:
 * 修改历史:
 */
public final class OrgVirtualNodeConfigExcel {

    /**
     * 默认Excel文件{@value}
     */
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "template/org/virtual/orgVirtualNodeExport.xlsx";
    /**
     * 默认排序字段{@value}
     */
    public static final String SORT_FIELD = "createTime";
    /**
     * 业务名称
     */
    public static final String BUSINESS_NAME = "业务组织树";
    /**
     * 默认服务配置表名
     */
    public static final String SN_BUSINESS_CONFIG = "业务组织树";
    /**
     * 默认服务配置表名
     */
    public static final String SN_BUSINESS_ACCOUNT_CONFIG = "关联人员";
    /**
     *  每次导入1000条数据
     */
    public static final int IMPORT_BATCH_SIZE = 1000;

    /**
     * 服务醘
     */
    private static final List<ExcelSheet> SHEETS = Stream.of(
            new ExcelSheet(0, SN_BUSINESS_CONFIG),
            new ExcelSheet(1, SN_BUSINESS_ACCOUNT_CONFIG))
            .collect(Collectors.toList());


    /**
     * 构建导入导出属性
     */
    public static final BusinessAttribute ORG_VIRTUAL_NODE_EXCEL_ATTRIBUTE = BusinessAttribute
            .builder()
            .name(BUSINESS_NAME)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(DEFAULT_TEMPLATE_FILE_NAME)
            .sheets(SHEETS)
            .build();

    /**
     * 获取ExcelSheet
     *
     * @return List<ExcelSheet> ExcelSheet列表
     */
    public static List<ExcelSheet> getSheets() {
        return SHEETS;
    }
}
