package com.xforceplus.business.org.virtual.service;

import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import org.springframework.stereotype.Service;

import java.util.List;

import static com.xforceplus.business.excel.ExcelFile.PARAMS_QUERY;
import static com.xforceplus.business.org.virtual.service.OrgVirtualNodeConfigExcel.SN_BUSINESS_ACCOUNT_CONFIG;
import static com.xforceplus.business.org.virtual.service.OrgVirtualNodeConfigExcel.SN_BUSINESS_CONFIG;

/**
 * 版权：    上海云砺信息科技有限公司
 *
 * @author: duanhy
 * 创建时间: 2021/1/11 15:18
 * 功能描述:
 */
@Service
public class OrgVirtualNodeExportServiceImpl implements ExcelWriteService {

    /**
     * 业务组织树服务
     */
    private final OrgVirtualNodeService orgVirtualNodeService;

    public OrgVirtualNodeExportServiceImpl(OrgVirtualNodeService orgVirtualNodeService) {
        this.orgVirtualNodeService = orgVirtualNodeService;
    }

    /**
     * 获取导入类型，用于Event事件调整导入方法
     * @return ImportBusinessType
     */
    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_VIRTUAL_NODE_CONFIG_EXCEL_FILE;
    }

    /**
     * 导出公共方法
     *
     * @param context 上下文
     * @return Context
     */
    @Override
    public void write(Context context) {
        OrgVirtualNodeModel.Request.ExcelExportQuery query = context.getParam(PARAMS_QUERY, OrgVirtualNodeModel.Request.ExcelExportQuery.class);
        //租户Id
        Long tenantId = context.getFileDTO().getTenantId();
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        query.setTenantId(tenantId);
        for (String sheetName : query.getSheets()) {
            //业务组织
            switch (sheetName) {
                case SN_BUSINESS_CONFIG:
                    List<OrgVirtualNodeModel.Response.ExcelExportModel> orgModes = this.orgVirtualNodeService.listNodeToExcel(query);
                    simpleExcelWriter.fill(sheetName, orgModes);
                    break;
                case SN_BUSINESS_ACCOUNT_CONFIG:
                    List<OrgVirtualNodeModel.Response.ExcelExportModel> list = this.orgVirtualNodeService.listNodeRelAccountToExcel(query);
                    simpleExcelWriter.fill(sheetName, list);
                    break;
                default:
                    break;

            }
        }
    }
}
