package com.xforceplus.business.org.virtual.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.org.virtual.dto.OrgVirtualNodeImportDto;
import com.xforceplus.business.org.virtual.dto.OrgVirtualNodeRelUserImportDto;
import com.xforceplus.business.service.ExcelReaderService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

import static com.xforceplus.business.org.virtual.service.OrgVirtualNodeConfigExcel.SN_BUSINESS_ACCOUNT_CONFIG;
import static com.xforceplus.business.org.virtual.service.OrgVirtualNodeConfigExcel.SN_BUSINESS_CONFIG;

/**
 * @author dhy
 */
@Service
public class OrgVirtualNodeImportServiceImpl implements ExcelReaderService {
    public static final String TREE_ACTION_CREATE = "新建";
    public static final String TREE_ACTION_DELETE = "删除";
    public static final String TREE_BIND_USER_ACTION_CREATE = "绑定";
    public static final String TREE_BIND_USER_ACTION_DELLETE = "解绑";
    public static final String TREE_BIND_USER_CONTRO_FLAG_CURRENT = "当前组织";
    public static final String TREE_BIND_USER_CONTRO_FLAG_SUB = "当前组织及下级组织";
    public static final String TREE_BIND_USER_ADMIN_FLAG_YES = "1";


    /**
     * 操作列表
     */
    public static final List<String> ACTION_LISTS = Arrays.asList(TREE_ACTION_CREATE, TREE_ACTION_DELETE);
    /**
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(OrgVirtualNodeImportServiceImpl.class);
    @Resource
    private OrgVirtualNodeService orgVirtualNodeService;
    @Resource
    private OrgVirtualNodeUserService orgVirtualNodeUserService;

    /**
     * 获取导入类型，用于Event事件调整导入方法
     * @return ImportBusinessType
     */
    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_VIRTUAL_NODE_IMPORT;
    }

    /**
     * 异步导出处理
     *
     * @param context 上下文
     * @return Context
     */
    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());

            String sheetName = sheet.getSheetName();

            if (SN_BUSINESS_CONFIG.equals(sheetName)) {
                //构建监听器
                AnalysisEventListener<OrgVirtualNodeImportDto> excelDataListener = SimpleDataReadListener.listener(context, (rows) -> {
                    this.saveData(messageRows, context, rows);
                });
                //开始处理
                context.getSimpleExcelReader().read(OrgVirtualNodeImportDto.class, excelDataListener, sheetName);

            } else if (SN_BUSINESS_ACCOUNT_CONFIG.equals(sheetName)) {
                //构建监听器
                AnalysisEventListener<OrgVirtualNodeRelUserImportDto> excelDataListener = SimpleDataReadListener.listener(context, (rows) -> {
                    this.saveDataRel(messageRows, context, rows);
                });
                //开始处理
                context.getSimpleExcelReader().read(OrgVirtualNodeRelUserImportDto.class, excelDataListener, sheetName);
            }
        }
        return context;
    }

    /**
     * 写入数据 业务业务组织树
     *
     * @param list
     */
    public void saveData(MessageRow messageRows, Context context, List<OrgVirtualNodeImportDto> list) {
        if (logger.isDebugEnabled()) {
            logger.debug("list:{}", JSON.toJSONString(list));
        }
        Long typeId = Long.valueOf(context.getParams().get("typeId").toString());
        if (null == typeId) {
            logger.warn("获取参数typeId失败");
            return;
        }

        for (OrgVirtualNodeImportDto dto : list) {
            if (logger.isDebugEnabled()) {
                logger.debug("dto:{}", JSON.toJSONString(dto));
            }

            if (!dto.getValidatedStatus()) {
                messageRows.fail(dto.getRowIndex(), dto.getValidatedMessage());
                continue;
            }
            String msg = orgVirtualNodeService.importSave(dto, context.getFileDTO().getTenantId(), typeId);
            if (StringUtils.isNoneBlank(msg)) {
                messageRows.fail(dto.getRowIndex(), msg);
            } else {
                messageRows.success(dto.getRowIndex());
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }


    /**
     * 写入数据 业务业务组织树与人员绑定
     *
     * @param list
     */
    public void saveDataRel(MessageRow messageRows, Context context, List<OrgVirtualNodeRelUserImportDto> list) {
        if (logger.isDebugEnabled()) {
            logger.debug("list:{}", JSON.toJSONString(list));
        }
        Long typeId = Long.valueOf(context.getParams().get("typeId").toString());
        if (null == typeId) {
            logger.warn("获取参数typeId失败");
            return;
        }

        for (OrgVirtualNodeRelUserImportDto dto : list) {
            if (logger.isDebugEnabled()) {
                logger.debug("dto:{}", JSON.toJSONString(dto));
            }

            if (!dto.getValidatedStatus()) {
                messageRows.fail(dto.getRowIndex(), dto.getValidatedMessage());
                continue;
            }
            String msg = orgVirtualNodeUserService.importSave(dto, context.getFileDTO().getTenantId(), typeId);
            if (StringUtils.isNoneBlank(msg)) {
                messageRows.fail(dto.getRowIndex(), msg);
            } else {
                messageRows.success(dto.getRowIndex());
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }
}
