package com.xforceplus.business.org.virtual.service;

import com.google.common.collect.Lists;
import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.business.excel.ExcelValidator;
import com.xforceplus.business.org.virtual.dto.OrgVirtualNodeRelUserImportDto;
import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.dao.OrgVirtualNodeDao;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;

import static com.xforceplus.business.org.virtual.service.OrgVirtualNodeImportServiceImpl.*;


/**
 * 保存 虚拟虚拟组织树节点-用户关联表
 *
 * @author duanhy
 */
@Service
public class OrgVirtualNodeUserService {

    private static final Logger logger = LoggerFactory.getLogger(OrgVirtualNodeUserService.class);

    private final OrgVirtualNodeDao orgVirtualNodeDao;

    @Resource
    private OrgVirtualNodeService orgVirtualNodeService;
    @Resource
    private UserService userService;

    @Resource
    private TenantService tenantService;


    public OrgVirtualNodeUserService(OrgVirtualNodeDao orgVirtualNodeDao) {
        this.orgVirtualNodeDao = orgVirtualNodeDao;
    }

    @Transactional(rollbackFor = Exception.class)
    public String importSave(OrgVirtualNodeRelUserImportDto dto, Long tenantId, Long typeId) {

        List<String> errMsg = new ArrayList<>();

        ExcelValidator.validate(dto);

        if (StringUtils.isNotBlank(dto.getValidatedMessage())) {
            errMsg.add(dto.getValidatedMessage());
        }

        Optional<Long> optionalNodeId = orgVirtualNodeDao.findByNodeTypeIdAndOrgCodeAndTenantId(tenantId, typeId, dto.getOrgCode());
        if (!optionalNodeId.isPresent()) {
            errMsg.add("不存在的业务组织[" + dto.getOrgCode() + "]");
        }
        Tenant tenant = tenantService.findById(tenantId);
        String username = dto.getUsername();
        String tenantUsername = userService.getDomainAccountName(username, tenant.getTenantCode());

        Optional<User> userOptional = userService.findByTenantIdAndUsername(tenantId, tenantUsername);
        if (!userOptional.isPresent()) {
            //fix bug: 旧的账号可能没有添加tenantCode,使用用户名查找
            userOptional = userService.findByTenantIdAndUsername(tenantId, username);
            if (!userOptional.isPresent()) {
                errMsg.add("不存在的账号[" + dto.getUsername() + "]");
            }
        }
        if (!CollectionUtils.isEmpty(errMsg)) {
            return String.join(";", errMsg);
        }
        if (userOptional.isPresent()) {
            User user = userOptional.get();
            if (TREE_BIND_USER_ACTION_CREATE.equals(dto.getAction())) {
                OrgVirtualNodeModel.Request.BindUsers bindUsers = new OrgVirtualNodeModel.Request.BindUsers();
                bindUsers.setUserIds(Lists.newArrayList(user.getId()));

                optionalNodeId.ifPresent(nodeId -> orgVirtualNodeService.bindUsers(tenantId, nodeId, bindUsers));
                if (TREE_BIND_USER_CONTRO_FLAG_SUB.equals(dto.getControlFlag())) {
                    OrgVirtualNodeModel.Request.UsersScope usersScope = new OrgVirtualNodeModel.Request.UsersScope();
                    usersScope.setControlFlag(1);
                    usersScope.setUserIds(Lists.newArrayList(user.getId()));
                    optionalNodeId.ifPresent(nodeId -> orgVirtualNodeService.updateControlScope(tenantId,nodeId,usersScope));
                }

                // 当选择1时 标识此账号是部门领导
                if (TREE_BIND_USER_ADMIN_FLAG_YES.equals(dto.getAdminFlag())) {
                    OrgVirtualNodeModel.Request.BindAdminInfo bindAdminInfo = new OrgVirtualNodeModel.Request.BindAdminInfo();
                    OrgVirtualNodeModel.Request.AdminInfo adminInfo = new OrgVirtualNodeModel.Request.AdminInfo();
                    adminInfo.setUserId(user.getId());
                    adminInfo.setSort(1);
                    bindAdminInfo.setAdmins(Lists.newArrayList(adminInfo));
                    optionalNodeId.ifPresent(nodeId -> orgVirtualNodeService.bindAdminInfo(tenantId, nodeId, bindAdminInfo));
                }

            } else if (TREE_BIND_USER_ACTION_DELLETE.equals(dto.getAction())) {
                OrgVirtualNodeModel.Request.UnbindUsers unbindUsers = new OrgVirtualNodeModel.Request.UnbindUsers();
                unbindUsers.setUserIds(Lists.newArrayList(user.getId()));
                optionalNodeId.ifPresent(nodeId -> orgVirtualNodeService.unbindUsers(tenantId,nodeId,unbindUsers));
            }
        }

        return null;
    }
}