package com.xforceplus.business.org.virtual.service;

import com.xforceplus.business.excel.BusinessAttribute;
import com.xforceplus.business.excel.ExcelSheet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;


/**
* @copyright © 上海云砺信息科技有限公司
* @author zhouxin
* @date 2021/8/4 16:49
*/
public final class OrgVirtualOrgStructConfigExcel {

    /**
     * 默认Excel文件{@value}
     */
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "template/org/virtual/orgVirtualOrgStructExport.xlsx";
    /**
     * 默认排序字段{@value}
     */
    public static final String SORT_FIELD = "createTime";
    /**
     * 业务名称
     */
    public static final String BUSINESS_NAME = "业务组织关联的行政组";
    /**
     * 默认服务配置表名
     */
    public static final String SN_BUSINESS_CONFIG = "业务组织关联的行政组织";
    /**
     *  每次导入1000条数据
     */
    public static final int IMPORT_BATCH_SIZE = 1000;

    /**
     * 服务醘
     */
    private static final List<ExcelSheet> SHEETS = Stream.of(
            new ExcelSheet(0, SN_BUSINESS_CONFIG))
            .collect(Collectors.toList());

    /**
     * 构建导入导出属性
     */
    public static final BusinessAttribute ORG_VIRTUAL_ORG_STRUCT_EXCEL_ATTRIBUTE = BusinessAttribute
            .builder()
            .name(BUSINESS_NAME)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(DEFAULT_TEMPLATE_FILE_NAME)
            .sheets(SHEETS)
            .build();

    /**
     * 获取ExcelSheet
     *
     * @return List<ExcelSheet> ExcelSheet列表
     */
    public static List<ExcelSheet> getSheets() {
        return SHEETS;
    }
}
