package com.xforceplus.business.org.virtual.service;

import static com.xforceplus.business.excel.ExcelFile.PARAMS_QUERY;
import static com.xforceplus.business.org.virtual.service.OrgVirtualOrgStructConfigExcel.SN_BUSINESS_CONFIG;

import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.api.model.OrgVirtualOrgStructRelModel.Request;
import com.xforceplus.api.model.OrgVirtualOrgStructRelModel.Response.ExcelExportModel;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import java.util.List;
import org.springframework.stereotype.Service;

/**
* @copyright © 上海云砺信息科技有限公司
* @author zhouxin
* @date 2021/8/4 17:08
*/
@Service
public class OrgVirtualOrgStructExportServiceImpl implements ExcelWriteService {

    /**
     * 业务组织服务
     */
    private final OrgVirtualOrgStructService orgVirtualOrgStructService;

    public OrgVirtualOrgStructExportServiceImpl(OrgVirtualOrgStructService orgVirtualOrgStructService) {
        this.orgVirtualOrgStructService = orgVirtualOrgStructService;
    }

    /**
     * 获取导入类型，用于Event事件调整导入方法
     * @return ImportBusinessType
     */
    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_VIRTUAL_ORG_STRUCT_CONFIG_EXCEL_FILE;
    }

    /**
     * 导出公共方法
     *
     * @param context 上下文
     * @return Context
     */
    @Override
    public void write(Context context) {
        Request.ExcelExportQuery query = context.getParam(PARAMS_QUERY, Request.ExcelExportQuery.class);
        //租户Id
        Long tenantId = context.getFileDTO().getTenantId();
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        query.setTenantId(tenantId);
        for (String sheetName : query.getSheets()) {
            //业务组织
            if (SN_BUSINESS_CONFIG.equals(sheetName)) {
                List<ExcelExportModel> list = this.orgVirtualOrgStructService.listToExcel(query);
                simpleExcelWriter.fill(sheetName, list);
            }
        }
    }
}
