package com.xforceplus.business.org.virtual.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.org.virtual.dto.OrgVirtualImportDto;
import com.xforceplus.business.org.virtual.dto.OrgVirtualOrgStructImportDto;
import com.xforceplus.business.service.ExcelReaderService;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
* @copyright © 上海云砺信息科技有限公司
* @author zhouxin
* @date 2021/8/4 17:05
*/
@Service
public class OrgVirtualOrgStructImportServiceImpl implements ExcelReaderService {
    public static final String ACTION_CREATE = "新增";
    public static final String ACTION_DELETE = "删除";
    /**
     * 操作列表
     */
    public static final List<String> ACTION_LISTS = Arrays.asList(ACTION_CREATE, ACTION_DELETE);
    /**
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(OrgVirtualOrgStructImportServiceImpl.class);

    @Resource
    private OrgVirtualOrgStructService orgVirtualOrgStructService;

    /**
     * 获取导入类型，用于Event事件调整导入方法
     * @return ImportBusinessType
     */
    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_VIRTUAL_ORG_STRUCT_CONFIG_EXCEL_FILE;
    }

    /**
     * 异步导出处理
     *
     * @param context 上下文
     * @return Context
     */
    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            //构建监听器
            AnalysisEventListener<OrgVirtualOrgStructImportDto> excelDataListener = SimpleDataReadListener.listener(context, (rows) -> {
                this.saveData(messageRows, context, rows);
            });
            //开始处理
            context.getSimpleExcelReader().read(OrgVirtualImportDto.class, excelDataListener);
        }
        return context;
    }

    /**
     * 写入数据
     *
     * @param list
     */
    public void saveData(MessageRow messageRows, Context context, List<OrgVirtualOrgStructImportDto> list) {
        if (logger.isDebugEnabled()) {
            logger.debug("list:{}", JSON.toJSONString(list));
        }
        for (OrgVirtualOrgStructImportDto dto : list) {
            if (logger.isDebugEnabled()) {
                logger.debug("dto:{}", JSON.toJSONString(dto));
            }
            String msg = orgVirtualOrgStructService.importSave(dto, context.getFileDTO().getTenantId());
            if (StringUtils.isNoneBlank(msg)) {
                messageRows.fail(dto.getRowIndex(), msg);
            } else {
                messageRows.success(dto.getRowIndex());
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }
}
