package com.xforceplus.business.outsideCompany;


import com.xforceplus.api.common.response.ResponseEntity;
import io.swagger.annotations.Api;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Collections;
import java.util.List;

/**
 * @author geewit
 */
@Api(value = "人员外部公司")
@Controller
@RequestMapping(value = "/companies")
public class OutsideCompanyController {

    /**
     * @param userId
     * @param taxNum
     * @return
     */
    @ResponseBody
    @RequestMapping(name = "获取单个人员外部公司", value = "/{tenantId}/{userId}/{taxNum}", method = RequestMethod.GET)
    public ResponseEntity<String> get(@PathVariable("tenantId") Long tenantId, @PathVariable("userId") Long userId, @PathVariable("taxNum") String taxNum) {
        return ResponseEntity.ok(null);
    }

    @ResponseBody
    @RequestMapping(name = "获取人员外部公司列表", value = "/{tenantId}/{userId}", method = RequestMethod.GET)
    public ResponseEntity<List> list(@PathVariable("tenantId") Long tenantId, @PathVariable("userId") Long userId) {
        return ResponseEntity.ok(Collections.emptyList());
    }

    @ResponseBody
    @RequestMapping(name = "获取租户外部公司列表", value = "/{tenantId}", method = RequestMethod.GET)
    public ResponseEntity<List> list(@PathVariable("tenantId") Long tenantId) {
        return ResponseEntity.ok(Collections.emptyList());
    }

}
