/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: MessageContext.java   2021-01-13 15-34-52
 * Author: Evan
 */
package com.xforceplus.business.pub.dto;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * Title: Pub消息下上文
 * </p>
 * <p>
 * Description: Pub消息下上文
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-01-13 15-34-52
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class PubContext {
    /**
     * 发送消息内容 （JSON）
     */
    private String content;

    /**
     * 参数
     */
    private String code;
    /**
     * 参数
     */
    private Map<String, String> param;

    private PubContext() {

    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String content;
        private String code;
        private Map<String, String> param;

        private Builder() {
            param = new HashMap<>(3);
        }


        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder param(Map<String, String> param) {
            this.param.putAll(param);
            return this;
        }

        /**
         * 参数配置
         *
         * @param key
         * @param value
         * @return Builder
         */
        public Builder param(String key, String value) {
            this.param.put(key, value);
            return this;
        }

        public PubContext build() {
            PubContext messageContext = new PubContext();
            messageContext.setContent(content);
            messageContext.setCode(code);
            messageContext.setParam(param);
            return messageContext;
        }
    }
}
