package com.xforceplus.business.pub.service;

import com.xforceplus.config.PubsubConfig;
import com.xforceplus.janus.pubsub.sdk.IMessageListener;
import com.xforceplus.janus.pubsub.sdk.MCFactory;
import com.xforceplus.janus.pubsub.sdk.msg.SealedMessage;
import com.xforceplus.janus.pubsub.sdk.utils.SealedMessageBuilder;
import io.geewit.web.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.Map;

/**
 * @author feihu.wang
 */
@SuppressWarnings("all")
@ConditionalOnProperty(prefix = "pubsub", name = "enable", havingValue = "true")
@Service
public class PubsubService {
    private static Logger logger = LoggerFactory.getLogger(PubsubService.class);

    private MCFactory pubsubFactory;

    @Autowired
    private PubsubConfig pubsubConfig;

    @PostConstruct
    public void init() {
        try {
            pubsubFactory = MCFactory.getInstance(pubsubConfig.getUsername(), pubsubConfig.getPassword(), pubsubConfig.getHost(), pubsubConfig.getPort());
        } catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public void register(String requestName, IMessageListener listener, String... tags) {
        pubsubFactory.registerListener(requestName, listener, 1, tags);
    }


    public void acknowlege(SealedMessage sealedMessage) {
        pubsubFactory.acknowlege(sealedMessage);
    }


    /**
     * @param requestName 订阅业务类型，业务类型由数据发布方定义
     * @param message     消息体
     * @param tagkvs      标签字段与字段值
     */
    public String sendMessage(String requestName, String message, Map<String, String> tagkvs) {
        logger.info("sendMessage requestName ={} ", requestName);
        logger.info("sendMessage message ={}", message);
        logger.debug("sendMessage description ={}", JsonUtils.toJson(tagkvs));
        try {
            SealedMessage sealedMessage = SealedMessageBuilder.buildSendMsg(requestName, message, tagkvs);
            return pubsubFactory.sendMessage(sealedMessage);
        } catch (Exception e) {
            String error = "sendMessage pub error = " + e.getMessage();
            logger.warn(error, e);
            return null;
        }
    }

}
