package com.xforceplus.business.resource.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ResourceModel;
import com.xforceplus.api.model.ServiceApiModel.Request.Query;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.business.resource.service.ServiceApiService;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.ServiceApi;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.Min;


/**
 * 服务API
 *
 * @author geewit
 */
@SuppressWarnings("all")
@Api(value = "服务接口相关接口", tags = {"resources", "serviceApi"})
@Validated
@Controller
public class ServiceApiController implements com.xforceplus.api.tenant.resource.ServiceApiApi {
    private final static Logger logger = LoggerFactory.getLogger(ServiceApiController.class);

    private final ServiceApiService serviceApiService;

    private final ResourceService resourceService;

    public ServiceApiController(ServiceApiService serviceApiService, ResourceService resourceService) {
        this.serviceApiService = serviceApiService;
        this.resourceService = resourceService;
    }

    @AuthorizedDefinition(resources = {"xforce:operation:serviceApi:read"})
    @ApiOperation(value = "租户关联服务包接口分页列表")
    @Override
    public ResponseEntity<Page<ServiceApi>> page(long tenantId,
                                                 Query query,
                                                 Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort(pageable, Sort.by(Sort.Direction.DESC, "createTime"));

        if (tenantId > 0) {
            query.setTenantId(tenantId);
        }
        Page<ServiceApi> result = serviceApiService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources = {"xforce:operation:serviceApi:save"})
    @ApiOperation(value = "租户关联服务包接口信息")
    @Override
    public ResponseEntity<ServiceApi> info(long tenantId, long id) {
        ServiceApi result = serviceApiService.findById(id);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources = {"xforce:operation:serviceApi:read"})
    @ApiOperation(value = "租户关联服务包接口对应的资源码分页列表")
    @Override
    public ResponseEntity<Page<Resource>> resources(long tenantId, long serviceApiId, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort(pageable, Sort.by(Sort.Direction.DESC, "createTime"));

        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        if (tenantId > 0) {
            query.setTenantId(tenantId);
        }
        query.setServiceApiId(serviceApiId);
        Page<Resource> result = resourceService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }
}
