/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ResourceDTO.java   2020-10-19 17-31-02
 * Author: Evan
 */
package com.xforceplus.business.resource.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.validation.constraints.StringInclude;
import lombok.Getter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.*;

/**
 * <p>
 * Title: ResourceExcelDTO
 * </p>
 * <p>
 * Description: ResourceExcelDTO
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-19 17-31-02
 * @since V1.0
 */
@Getter
@ToString
public class ResourceExcelDTO extends DataRow implements Comparable<ResourceExcelDTO> {

    /**
     * 操作类型
     */
    @NotBlank(message = "操作 不能为空")
    @StringInclude(message = "操作 应该为:{\"新增\",\"修改\"}", range = {"新增", "修改"})
    @ExcelProperty(value = "操作")
    private String action;

    /**
     * 资源码名称
     */
    @ExcelProperty(value = "资源码名称")
    @NotEmpty(message = "资源码名称不能为空")
    @Size(min = 1, max = 120, message = "资源码名称长度介于1~120个字符之间")
    private String resourceName;

    /**
     * 资源码Code
     */
    @NotEmpty(message = "资源码Code不能为空")
    @Size(min = 1, max = 120, message = "资源码Code长度介于1~120个字符之间")
    @ExcelProperty(value = "资源码Code")
    private String resourceCode;

    /**
     * 应用Id
     */
    @ExcelProperty(value = "应用ID")
    @NotNull(message = "应用ID不能为空")
    @Digits(message = "应用ID必须是数据类型", integer = 12, fraction = 0)
    private String appId;

    /**
     * 上级资源码
     */
    @ExcelProperty(value = "上级资源码")
    @Size(min = 1, max = 120, message = "上级资源码长度介于1~120个字符之间")
    private String parentResourceCode;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setResourceName(String resourceName) {
        this.resourceName = StringUtils.trim(resourceName);
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = StringUtils.trim(resourceCode);
    }

    public void setAppId(String appId) {
        this.appId = StringUtils.trim(appId);
    }

    public void setParentResourceCode(String parentResourceCode) {
        this.parentResourceCode = StringUtils.trim(parentResourceCode);
    }

    @Override
    public int compareTo(ResourceExcelDTO that) {
        if(StringUtils.isBlank(this.parentResourceCode) && StringUtils.isNotBlank(that.parentResourceCode)) {
            return -1;
        }
        if(StringUtils.isNotBlank(this.parentResourceCode) && StringUtils.isBlank(that.parentResourceCode)) {
            return 1;
        }
        if(StringUtils.isBlank(this.resourceCode)) {
            if(StringUtils.isBlank(that.resourceCode)) {
                return 0;
            } else {
                return -1;
            }
        } else {
            if(StringUtils.isBlank(that.resourceCode)) {
                return 1;
            } else {
                return this.resourceCode.compareTo(that.resourceCode);
            }
        }
    }
}
