/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ResourceSetExcelDTO.java   2020-10-19 17-50-57
 * Author: Evan
 */
package com.xforceplus.business.resource.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.validation.constraints.StringInclude;
import lombok.Getter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.*;

/**
 * <p>
 * Title: 功能集DTO
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-19 17-50-57
 * @since V1.0
 */
@Getter
@ToString
public class ResourceSetExcelDTO extends DataRow {
    /**
     * 功能集名称
     */
    @ExcelProperty("功能集名称")
    @NotEmpty(message = "功能集名称不能为空")
    @Size(min = 1, max = 60, message = "功能集名称长度介于1~60个字符之间")
    protected String resourceSetName;
    /**
     * 功能集代码
     */
    @ExcelProperty("功能集代码")
    @NotEmpty(message = "功能集名称不能为空")
    @Size(min = 1, max = 255, message = "功能集名称长度介于1~255个字符之间")
    protected String resourceSetCode;
    /**
     * 应用ID
     */
    @ExcelProperty("应用ID")
    @NotNull(message = "应用ID不能为空")
    @Digits(message = "应用ID必须是数据类型", integer = 12, fraction = 0)
    protected String appId;
    /**
     * 状态 "0","1"
     */
    @ExcelProperty(value = "状态")
    @NotNull(message = "状态不能为空")
    @Range(min = 0, max = 1, message = "状态须为:\"0\",\"1\"")
    protected String status;
    /**
     * 操作类型
     */
    @NotBlank(message = "操作 不能为空")
    @StringInclude(message = "操作 应该为:{\"新增\",\"修改\"}", range = {"新增", "修改"})
    @ExcelProperty(value = "操作")
    private String action;

    public void setResourceSetName(String resourceSetName) {
        this.resourceSetName = StringUtils.trim(resourceSetName);
    }

    public void setResourceSetCode(String resourceSetCode) {
        this.resourceSetCode = StringUtils.trim(resourceSetCode);
    }

    public void setAppId(String appId) {
        this.appId = StringUtils.trim(appId);
    }

    public void setStatus(String status) {
        this.status = StringUtils.trim(status);
    }

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }
}
