/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ResourceSetResourceRelExcelDTO.java   2020-10-19 17-59-32
 * Author: Evan
 */
package com.xforceplus.business.resource.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.validation.constraints.StringInclude;
import lombok.Getter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-19 17-59-32
 * @since V1.0
 */
@Getter
@ToString
public class ResourceSetResourceExcelDTO extends DataRow {
    /**
     * 功能集代码
     */
    @ExcelProperty("关联功能集代码")
    @NotEmpty(message = "关联功能集代码不能为空")
    @Size(min = 1, max = 255, message = "关联功能集代码长度介于1~255个字符之间")
    protected String resourceSetCode;
    /**
     * 操作
     */
    @NotBlank(message = "操作 不能为空")
    @StringInclude(message = "操作 应该为:{\"绑定\",\"解绑\"}", range = {"绑定", "解绑"})
    @ExcelProperty(value = "操作")
    private String action;
    /**
     * 资源码
     */
    @ExcelProperty(value = "资源码Code")
    @NotEmpty(message = "资源码Code不能为空")
    @Size(min = 1, max = 120, message = "资源码Code长度介于1~120个字符之间")
    private String resourceCode;

    public void setResourceSetCode(String resourceSetCode) {
        this.resourceSetCode = StringUtils.trim(resourceSetCode);
    }

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = StringUtils.trim(resourceCode);
    }
}
