/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ServiceApiExcelDTO.java   2020-10-19 17-44-01
 * Author: Evan
 */
package com.xforceplus.business.resource.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.validation.constraints.StringInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.*;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-19 17-44-01
 * @since V1.0
 */
@Getter
@ToString
public class ServiceApiExcelDTO extends DataRow {

    /**
     * 操作类型
     */
    @NotBlank(message = "操作 不能为空")
    @StringInclude(message = "操作 应该为:{\"新增并绑定\",\"解绑\"}", range = {"新增并绑定", "解绑"})
    @ExcelProperty(value = "操作")
    private String action;

    /**
     * API名称
     */
    @ExcelProperty(value = "API名称")
    @NotEmpty(message = "API名称不能为空")
    @Size(min = 1, max = 100, message = "API名称长度介于1~100个字符之间")
    private String serviceApiName;

    /**
     * 服务ApiPath
     */
    @ExcelProperty(value = "服务ApiPath")
    @NotEmpty(message = "服务ApiPath不能为空")
    @Size(min = 1, max = 255, message = "服务ApiPath长度介于1~255个字符之间")
    private String serviceApiPath;

    /**
     * 路由Path
     */
    @ExcelProperty(value = "路由Path")
    @NotEmpty(message = "路由Path不能为空")
    @Size(min = 1, max = 255, message = "路由Path长度介于1~255个字符之间")
    private String path;

    /**
     * 服务URL
     */
    @ExcelProperty(value = "服务URL")
    @NotEmpty(message = "服务URL不能为空")
    @Size(min = 1, max = 255, message = "服务URL长度介于1~255个字符之间")
    private String serviceApiUrl;


    /**
     * 应用ID
     */
    @ApiModelProperty(value = "应用ID")
    @NotEmpty(message = "应用ID不能等于空")
    @Digits(message = "必须是数据类型", integer = 12, fraction = 0)
    private String appId;

    /**
     * 路由ID
     */
    @ApiModelProperty(value = "路由ID")
    private String routeId;

    /**
     * 请求方式
     */
    @ExcelProperty(value = "请求方式")
    @NotNull(message = "应用ID不能为空")
    @StringInclude(message = "请求方式 应该为:{\"GET\", \"HEAD\", \"POST\", \"PUT\", \"PATCH\", \"DELETE\", \"OPTIONS\", \"TRACE\"}", range = {"GET", "HEAD", "POST", "PUT", "PATCH", "DELETE", "OPTIONS", "TRACE"})
    private String requestMethod;

    /**
     * 资源码Code
     */
    @ExcelProperty(value = "关联资源码")
    @NotEmpty(message = "资源码Code不能为空")
    @Size(min = 1, max = 120, message = "资源码Code长度介于1~120个字符之间")
    private String resourceCode;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setServiceApiName(String serviceApiName) {
        this.serviceApiName = StringUtils.trim(serviceApiName);
    }

    public void setServiceApiPath(String serviceApiPath) {
        this.serviceApiPath = StringUtils.trim(serviceApiPath);
    }

    public void setPath(String path) {
        this.path = StringUtils.trim(path);
    }

    public void setServiceApiUrl(String serviceApiUrl) {
        this.serviceApiUrl = StringUtils.trim(serviceApiUrl);
    }

    public void setAppId(String appId) {
        this.appId = StringUtils.trim(appId);
    }

    public void setRouteId(String routeId) {
        this.routeId = StringUtils.trim(routeId);
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = StringUtils.trim(requestMethod);
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = StringUtils.trim(resourceCode);
    }
}
