/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ServicePackage.java   2020-10-19 18-04-13
 * Author: Evan
 */
package com.xforceplus.business.resource.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.validation.constraints.StringInclude;
import lombok.Getter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-19 18-04-13
 * @since V1.0
 */
@Getter
@ToString
public class ServicePackageExcelDTO extends DataRow {
    /**
     * 产品服务包名称
     */
    @ExcelProperty("产品服务包名称")
    @NotEmpty(message = "产品服务包名称不能为空")
    @Size(min = 1, max = 120, message = "产品服务包名称长度介于1~120个字符之间")
    protected String servicePackageName;
    /**
     * 产品服务包代码
     */
    @ExcelProperty("产品服务包代码")
    @NotEmpty(message = "产品服务包代码不能为空")
    @Size(min = 1, max = 255, message = "产品服务包代码长度介于1~255个字符之间")
    protected String servicePackageCode;
    @ExcelProperty("应用ID")
    @NotEmpty(message = "应用ID不能等于空")
    @Digits(message = "应用ID必须是数据类型", integer = 12, fraction = 0)
    protected String appId;
    /**
     * 状态
     */
    @NotEmpty(message = "状态不能为空")
    @Range(max = 1, min = 0, message = "状态：请输入0或者 0-代表停用 1-代表启用")
    @ExcelProperty(value = "状态")
    protected String status;
    /**
     * 操作类型
     */
    @NotBlank(message = "操作 不能为空")
    @StringInclude(message = "操作 应该为:{\"新增\",\"修改\"}", range = {"新增", "修改"})
    @ExcelProperty(value = "操作")
    private String action;

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = StringUtils.trim(servicePackageName);
    }

    public void setServicePackageCode(String servicePackageCode) {
        this.servicePackageCode = StringUtils.trim(servicePackageCode);
    }

    public void setAppId(String appId) {
        this.appId = StringUtils.trim(appId);
    }

    public void setStatus(String status) {
        this.status = StringUtils.trim(status);
    }

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }
}
