/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ServicePackage.java   2020-10-19 18-04-13
 * Author: Evan
 */
package com.xforceplus.business.resource.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.validation.constraints.StringInclude;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-19 18-04-13
 * @since V1.0
 */
@Getter
@ToString
public class ServicePackageResourceSetExcelDTO extends DataRow {
    /**
     * 功能集代码
     */
    @ExcelProperty("功能集代码")
    @NotEmpty(message = "功能集名称不能为空")
    @Size(min = 1, max = 255, message = "功能集名称长度介于1~255个字符之间")
    protected String resourceSetCode;
    /**
     * 产品服务包代码
     */
    @ExcelProperty("关联产品服务代码")
    @NotEmpty(message = "关联产品服务代码不能为空")
    @Size(min = 1, max = 255, message = "关联产品服务代码长度介于1~255个字符之间")
    protected String servicePackageCode;
    /**
     * 操作类型
     */
    @NotBlank(message = "操作 不能为空")
    @StringInclude(message = "操作 应该为:{\"绑定\",\"解绑\"}", range = {"绑定", "解绑"})
    @ExcelProperty(value = "操作")
    private String action;

    public void setResourceSetCode(String resourceSetCode) {
        this.resourceSetCode = StringUtils.trim(resourceSetCode);
    }

    public void setServicePackageCode(String servicePackageCode) {
        this.servicePackageCode = StringUtils.trim(servicePackageCode);
    }

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }
}
