/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ResourceExcelConfig.java   2020-10-19 19-12-52
 * Author: Evan
 */
package com.xforceplus.business.resource.service;

import com.xforceplus.business.excel.BusinessAttribute;
import com.xforceplus.business.excel.ExcelSheet;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * <p>
 * Title: 资源码和服务API导出Excel配置信息
 * </p>
 * <p>
 * Description: 资源码和服务API导出Excel配置信息
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-19 19-12-52
 * @since V1.0
 */
public class ResourceExcelConfig {

    /**
     * 资源码导入导出
     */
    public static class ResourceServiceApiConfig {

        /**
         * 资源新增
         */
        public static final String RESOURCE_ACTION_ADD = "新增";

        /**
         * 资源修改
         */
        public static final String RESOURCE_ACTION_UPDATE = "修改";


        /**
         * 服务API新增
         */
        public static final String SERVICE_API_ACTION_ADD_BIND = "新增并绑定";

        /**
         * 服务API 绑定
         */
        public static final String SERVICE_API_ACTION_BIND = "绑定";

        /**
         * 服务API 解绑
         */
        public static final String SERVICE_API_ACTION_UN_BIND = "解绑";


        /**
         * 导出Excel模板文件{@value}
         */
        public static final String EXPORT_TEMPLATE_FILE_NAME = "template/resource/resourceExport.xlsx";

        /**
         * 导入功能模板文件：{@value}
         */
        public static final String IMPORT_TEMPLATE_FILE_NAME = "templates/batch/batch_resource_import_template.xlsx";
        /**
         * 默认排序字段{@value}
         */
        public static final String SORT_FIELD = "createTime";
        /**
         * 业务名称
         */
        public static final String BUSINESS_NAME = "资源码";

        /**
         * 默认服务配置表名
         */
        public static final String RESOURCE_SHEET = "资源码";

        /**
         * 默认服务配置表名
         */
        public static final String SERVICE_API_SHEET = "服务API";

        /**
         * 默认导入的数据：{@value}
         */
        public static final Integer IMPORT_BATCH_SIZE = 3000;

        /**
         * 服务醘
         */
        private static final List<ExcelSheet> SHEETS = Stream.of(
                new ExcelSheet(0, RESOURCE_SHEET),
                new ExcelSheet(1, SERVICE_API_SHEET)
        ).collect(Collectors.toList());

        /**
         * 构建导入导出属性
         */
        public static final BusinessAttribute ATTRIBUTE = BusinessAttribute
                .builder()
                .name(BUSINESS_NAME)
                .batchSize(IMPORT_BATCH_SIZE)
                .exportTemplateFile(EXPORT_TEMPLATE_FILE_NAME)
                .importTemplateFile(IMPORT_TEMPLATE_FILE_NAME)
                .sheets(SHEETS)
                .build();

        /**
         * 获取ExcelSheet
         *
         * @return List<ExcelSheet> ExcelSheet列表
         */
        public static List<ExcelSheet> getSheets() {
            return SHEETS;
        }
    }


    /**
     * 功能集导入导出配置
     */
    public static class ResourceSetConfig {
        /**
         * 新增
         */
        public static final String RESOURCE_SET_ACTION_ADD = "新增";

        /**
         * 修改
         */
        public static final String RESOURCE_SET_ACTION_UPDATE = "修改";

        /**
         * 资源修改
         */
        public static final String RESOURCE_SET_RESOURCE_ACTION_BIND = "绑定";

        /**
         * 资源修改
         */
        public static final String RESOURCE_SET_RESOURCE_ACTION_UN_BIND = "解绑";

        /**
         * 导出Excel模板文件{@value}
         */
        public static final String EXPORT_TEMPLATE_FILE_NAME = "template/resource/resource-setExport.xlsx";

        /**
         * 导入功能模板文件：{@value}
         */
        public static final String IMPORT_TEMPLATE_FILE_NAME = "templates/batch/batch_resource_set_import_template.xlsx";
        /**
         * 默认排序字段{@value}
         */
        public static final String SORT_FIELD = "createTime";
        /**
         * 业务名称
         */
        public static final String BUSINESS_NAME = "功能集";

        /**
         * 默认服务配置表名
         */
        public static final String RESOURCE_SET_SHEET = "功能集";

        /**
         * 默认服务配置表名
         */
        public static final String RESOURCE_SHEET = "资源码";

        /**
         * 默认导入的数据：{@value}
         */
        public static final Integer IMPORT_BATCH_SIZE = 3000;

        /**
         * 服务醘
         */
        private static final List<ExcelSheet> SHEETS = Stream.of(
                new ExcelSheet(0, RESOURCE_SET_SHEET),
                new ExcelSheet(1, RESOURCE_SHEET)
        ).collect(Collectors.toList());

        /**
         * 构建导入导出属性
         */
        public static final BusinessAttribute ATTRIBUTE = BusinessAttribute
                .builder()
                .name(BUSINESS_NAME)
                .batchSize(IMPORT_BATCH_SIZE)
                .exportTemplateFile(EXPORT_TEMPLATE_FILE_NAME)
                .importTemplateFile(IMPORT_TEMPLATE_FILE_NAME)
                .sheets(SHEETS)
                .build();

        /**
         * 获取ExcelSheet
         *
         * @return List<ExcelSheet> ExcelSheet列表
         */
        public static List<ExcelSheet> getSheets() {
            return SHEETS;
        }
    }


    /**
     * 功能集导入导出配置
     */
    public static class ServicePackageConfig {
        /**
         * 新增
         */
        public static final String SERVICE_PACKAGE_ACTION_ADD = "新增";

        /**
         * 修改
         */
        public static final String SERVICE_PACKAGE_ACTION_UPDATE = "修改";

        /**
         * 绑定
         */
        public static final String SERVICE_PACKAGE_RESOURCE_SET_ACTION_BIND = "绑定";

        /**
         * 解绑
         */
        public static final String SERVICE_PACKAGE_RESOURCE_SET_ACTION_UN_BIND = "解绑";
        /**
         * 导出Excel模板文件{@value}
         */
        public static final String EXPORT_TEMPLATE_FILE_NAME = "template/resource/service-packageExport.xlsx";

        /**
         * 导入功能模板文件：{@value}
         */
        public static final String IMPORT_TEMPLATE_FILE_NAME = "templates/batch/batch_service_package_import_template.xlsx";
        /**
         * 默认排序字段{@value}
         */
        public static final String SORT_FIELD = "createTime";
        /**
         * 业务名称
         */
        public static final String BUSINESS_NAME = "产品服务";

        /**
         * 默认服务配置表名
         */
        public static final String SERVICE_PACKAGE_SHEET = "产品服务包";

        /**
         * 默认服务配置表名
         */
        public static final String RESOURCE_SET_SHEET = "关联功能集";

        /**
         * 默认导入的数据：{@value}
         */
        public static final Integer IMPORT_BATCH_SIZE = 3000;

        /**
         * 服务醘
         */
        private static final List<ExcelSheet> SHEETS = Stream.of(
                new ExcelSheet(0, SERVICE_PACKAGE_SHEET),
                new ExcelSheet(1, RESOURCE_SET_SHEET)
        ).collect(Collectors.toList());

        /**
         * 构建导入导出属性
         */
        public static final BusinessAttribute ATTRIBUTE = BusinessAttribute
                .builder()
                .name(BUSINESS_NAME)
                .batchSize(IMPORT_BATCH_SIZE)
                .exportTemplateFile(EXPORT_TEMPLATE_FILE_NAME)
                .importTemplateFile(IMPORT_TEMPLATE_FILE_NAME)
                .sheets(SHEETS)
                .build();

        /**
         * 获取ExcelSheet
         *
         * @return List<ExcelSheet> ExcelSheet列表
         */
        public static List<ExcelSheet> getSheets() {
            return SHEETS;
        }
    }
}
