package com.xforceplus.business.resource.service;

import com.xforceplus.dao.*;
import com.xforceplus.domain.resource.ResourcesetExtendDto;
import com.xforceplus.domain.resource.ServicePackageExtendDto;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.ServiceResourcesetRel;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.utils.excel.QueryUtils;
import com.xforceplus.utils.excel.ServicePackageWrapper;
import io.geewit.core.utils.reflection.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 导入导出服务包服务类
 *
 * @author lengmz
 */
@Service
public class ServicePackagePortService {

    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ServicePackageService servicePackageService;
    @Autowired
    private ServiceResourcesetRelDao serviceResourcesetRelDao;
    @Autowired
    private ResourcesetDao resourcesetDao;
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private ServicePackageDao servicePackageDao;
    @Autowired
    private AppDao appDao;

    private String operateUserName = "手动导入";


    public ServicePackageWrapper getExportData(List<Long> servicePackageIds) {
        Specification<ServicePackage> specification = QueryUtils.getSpecification("servicePackageId", servicePackageIds);
        List<ServicePackage> servicePackageList = servicePackageService.list(specification, Sort.unsorted());
        if (servicePackageList == null || servicePackageList.size() <= 0) {
            throw new UnknownException("所选id记录不存在。");
        }
        List<ServicePackageExtendDto> servicePackageExtendDtoList = new ArrayList<>(servicePackageList.size());
        for (ServicePackage servicePackage : servicePackageList) {
            ServicePackageExtendDto servicePackageExtendDto = new ServicePackageExtendDto();
            BeanUtils.copyProperties(servicePackage, servicePackageExtendDto);
            //String resourceCodes = getRelResourceCodes(servicePackage.getServicePackageId());
            //servicePackageExtendDto.setRelResourceCodes(resourceCodes);
            servicePackageExtendDtoList.add(servicePackageExtendDto);
        }
        ServicePackageWrapper result = new ServicePackageWrapper();
        result.setServicePackages(servicePackageExtendDtoList);
        if (CollectionUtils.isEmpty(servicePackageExtendDtoList)) {
            return result;
        }
        List<Long> existServicePackageIds = servicePackageExtendDtoList.stream().map(p -> p.getServicePackageId()).collect(Collectors.toList());
        Specification<ServiceResourcesetRel> specification2 = QueryUtils.getSpecification("servicePackageId", existServicePackageIds);
        List<ServiceResourcesetRel> serviceResourcesetRels = serviceResourcesetRelDao.findAll(specification2, Sort.unsorted());
        if (CollectionUtils.isEmpty(serviceResourcesetRels)) {
            return result;
        }
        List<ResourcesetExtendDto> resourcesetExtendDtoList = new ArrayList<>(serviceResourcesetRels.size());
        Map<Long, Integer> servicePackageIdAndIndex = getServicePackageIdAndIndex(result.getServicePackages());
        for (ServiceResourcesetRel item : serviceResourcesetRels) {
            ResourcesetExtendDto resourcesetExtendDto = new ResourcesetExtendDto();
            Optional<Resourceset> optional = resourcesetDao.findById(item.getResourcesetId());
            if (!optional.isPresent()) {
                continue;
            }
            Resourceset resourceset = optional.get();
            resourcesetExtendDto.setResourcesetName(resourceset.getResourcesetName());
            resourcesetExtendDto.setAppId(resourceset.getAppId());
            if (resourceset.getResourceId() != null && resourceset.getResourceId() > 0) {
                Optional<Resource> resourceOptional = resourceDao.findById(resourceset.getResourceId());
                resourceOptional.ifPresent(resource -> resourcesetExtendDto.setRelResourceCode(resource.getResourceCode()));
            }
            Integer index = servicePackageIdAndIndex.get(item.getServicePackageId());
            resourcesetExtendDto.setRelServicePackageIndex(index + 1);
            resourcesetExtendDtoList.add(resourcesetExtendDto);
        }
        result.setResourcesets(resourcesetExtendDtoList);
        return result;
    }

    private Map<Long, Integer> getServicePackageIdAndIndex(List<ServicePackageExtendDto> servicePackages) {
        if (servicePackages == null || servicePackages.size() <= 0) {
            return new HashMap<>();
        }
        Map<Long, Integer> map = new HashMap<>(servicePackages.size());
        for (int i = 0; i < servicePackages.size(); i++) {
            ServicePackageExtendDto servicePackageExtendDto = servicePackages.get(i);
            if (servicePackageExtendDto.getServicePackageId() != null && servicePackageExtendDto.getServicePackageId() > 0L) {
                map.put(servicePackageExtendDto.getServicePackageId(), i);
            }
        }
        return map;
    }


    public ServicePackageWrapper saveData(ServicePackageWrapper wrapper) {
        ServicePackageWrapper result = new ServicePackageWrapper();
        List<ServicePackageExtendDto> servicePackageExtendDtoList = wrapper.getServicePackages();
        List<ServicePackageExtendDto> existServicePackageList = saveServicePackage(servicePackageExtendDtoList);
        List<ResourcesetExtendDto> existRels = saveResourcesetRel(servicePackageExtendDtoList, wrapper.getResourcesets());
        result.setServicePackages(existServicePackageList);
        result.setResourcesets(existRels);
        return result;
    }

    private List<ResourcesetExtendDto> saveResourcesetRel(List<ServicePackageExtendDto> servicePackageExtendDtoList, List<ResourcesetExtendDto> resourcesets) {
        List<ResourcesetExtendDto> extendDtoList = new ArrayList<>();
        for (ResourcesetExtendDto item : resourcesets) {
            if (null == item.getAppId() || !appDao.existsById(item.getAppId())) {
                item.setReason("无效的appId。");
                extendDtoList.add(item);
                continue;
            }
            Resourceset resourceset = getOldResourceset(item.getResourcesetName(), item.getAppId(), item.getRelResourceCode());
            if (resourceset == null) {
                item.setReason("相关功能集不存在，请先导入功能集。");
                extendDtoList.add(item);
            } else {
                ServicePackageExtendDto servicePackageExtendDto
                        = servicePackageExtendDtoList.get(item.getRelServicePackageIndex() - 1);
                boolean exists = servicePackageService.saveResourcesetRel(servicePackageExtendDto.getServicePackageId(), resourceset.getResourcesetId(), operateUserName);
                if (exists) {
                    item.setReason("服务包和功能集已经关联。");
                    extendDtoList.add(item);
                }
            }
        }
        return extendDtoList;
    }

    private Resourceset getOldResourceset(String resourcesetName, Long appId, String relResourceCode) {
        List<Resourceset> list = resourcesetDao.findAll(new Specification<Resourceset>() {
            @Override
            public Predicate toPredicate(Root<Resourceset> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                List<Predicate> predicates = new ArrayList<>();
                predicates.add(builder.equal(root.<String>get("resourcesetName"), resourcesetName));
                if (appId != null && appId > 0L) {
                    predicates.add(builder.equal(root.<Long>get("appId"), appId));
                }
                if (!predicates.isEmpty()) {
                    query.where(predicates.stream().toArray(Predicate[]::new));
                }
                return query.getRestriction();
            }
        });
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Resourceset oldResourceset = null;
        for (Resourceset resourceset : list) {
            if (StringUtils.isBlank(relResourceCode)) {
                if ((resourceset.getResourceId() == null || resourceset.getResourceId() <= 0L)) {
                    oldResourceset = resourceset;
                    break;
                }
            } else {
                if ((resourceset.getResourceId() != null && resourceset.getResourceId() > 0L)) {
                    Optional<Resource> optionalResource = resourceDao.findById(resourceset.getResourceId());
                    if (!optionalResource.isPresent()) {
                        continue;
                    }
                    Resource resource = optionalResource.get();
                    if (StringUtils.equals(relResourceCode, resource.getResourceCode())) {
                        oldResourceset = resourceset;
                        break;
                    }
                }
            }
        }
        return oldResourceset;
    }

    public List<ServicePackageExtendDto> saveServicePackage(List<ServicePackageExtendDto> servicePackageExtendDtoList) {
        List<ServicePackageExtendDto> exists = new ArrayList<>();
        for (ServicePackageExtendDto servicePackageExtendDto : servicePackageExtendDtoList) {
            if (null == servicePackageExtendDto.getAppId() || !appDao.existsById(servicePackageExtendDto.getAppId())) {
                servicePackageExtendDto.setReason("无效的appId。");
                exists.add(servicePackageExtendDto);
                continue;
            }
            List<ServicePackage> list = servicePackageDao.findAll(new Specification<ServicePackage>() {
                @Override
                public Predicate toPredicate(Root<ServicePackage> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                    List<Predicate> predicates = new ArrayList<>();
                    predicates.add(builder.equal(root.<String>get("servicePackageName"), servicePackageExtendDto.getServicePackageName()));
                    if (servicePackageExtendDto.getAppId() != null && servicePackageExtendDto.getAppId() > 0L) {
                        predicates.add(builder.equal(root.<Long>get("appId"), servicePackageExtendDto.getAppId()));
                    }
                    if (!predicates.isEmpty()) {
                        query.where(predicates.stream().toArray(Predicate[]::new));
                    }
                    return query.getRestriction();
                }
            });
            ServicePackage oldServicePackage = null;
            if (CollectionUtils.isNotEmpty(list)) {
                oldServicePackage = list.get(0);
            }
            if (oldServicePackage == null) {
                ServicePackage servicePackage = new ServicePackage();
                BeanUtils.copyProperties(servicePackageExtendDto, servicePackage);
                oldServicePackage = servicePackageDao.saveAndFlush(servicePackage);
            } else {
                servicePackageExtendDto.setReason("该服务包已经存在。");
                exists.add(servicePackageExtendDto);
            }
            servicePackageExtendDto.setServicePackageId(oldServicePackage.getServicePackageId());
        }
        return exists;
    }

}
