/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelReaderService.java   2020-09-22 13-51-34
 * Author: Evan
 */
package com.xforceplus.business.service;

import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.reader.Context;
import java.util.HashMap;

/**
 * <p>
 * Title: ExcelReader
 * </p>
 * <p>
 * Description: ExcelReader接口
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-22 13-51-34
 * @since V1.0
 */
public interface ExcelReaderService {
    /**
     * 获取导入类型，用于Event事件调整导入方法
     * @return ImportBusinessType
     */
    BusinessType getBusinessType();

    /**
     * 避免报错，提供默认方法，需要各个实现类实现
     * @return
     */
    default HashMap<String,Integer> getSheetHeaderNumber(){
        return new HashMap<>(4);
    }

    /**
     * 导入定义
     *
     * @param context 上下文
     * @return Context
     */
    Context importExcel(Context context);
}
