/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelReaderService.java   2020-09-22 13-51-34
 * Author: Evan
 */
package com.xforceplus.business.service;

import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelFile;
import com.xforceplus.business.excel.reader.Context;
import org.springframework.data.domain.Page;

/**
 * <p>
 * Title: ExcelReader
 * </p>
 * <p>
 * Description: ExcelReader接口
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-22 13-51-34
 * @since V1.0
 */
public interface ExcelWriteService {
    /**
     * 获取导入类型，用于Event事件调整导入方法
     * @return ImportBusinessType
     */
    BusinessType getBusinessType();

    /**
     * 导出公共方法
     *
     * @param context 上下文
     * @return Context
     */
    void write(Context context);

    /**
     * 计算导出成功数Size
     *
     * @param page Page分页对象
     * @return int
     */
    default int calcSuccessSize(Page<?> page) {
        return this.calcSuccessSize(page, ExcelFile.START_PAGE);
    }

    /**
     * 计算导出成功数Size
     *
     * @param page      Page分页对象
     * @param startPage startPage
     * @return int 总数量
     */
    default int calcSuccessSize(Page<?> page, int startPage) {
        int size = page.getNumberOfElements();
        int number = page.getNumber();

        if (startPage > 0 && number > 0) {
            number = number - startPage < 0 ? 0 : number - startPage;
        }
        if (number > 1) {
            size = page.getNumber() * page.getSize() + page.getNumberOfElements();
        }
        return size;
    }
}
