package com.xforceplus.business.settle.service;

import com.xforceplus.dao.SettleFlowDao;
import com.xforceplus.dao.SettleFlowTemplateRelDao;
import com.xforceplus.dao.SettleTemplateDao;
import com.xforceplus.entity.SettleFlowTemplateRel;
import com.xforceplus.entity.SettleTemplate;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SettleTemplateService {
    private final static Logger logger = LoggerFactory.getLogger(SettleTemplateService.class);

    private final SettleTemplateDao templateDao;

    private final SettleFlowDao flowDao;

    private final SettleFlowTemplateRelDao flowTemplateRelDao;

    public SettleTemplateService(SettleTemplateDao templateDao, SettleFlowDao flowDao, SettleFlowTemplateRelDao flowTemplateRelDao) {
        this.templateDao = templateDao;
        this.flowDao = flowDao;
        this.flowTemplateRelDao = flowTemplateRelDao;
    }

    public SettleTemplate findById(long templateId) {
        return templateDao.findById(templateId, EntityGraphs.named(SettleTemplate.NAMED_ENTITY_GRAPH_DEFAULT)).orElseThrow(() -> new IllegalArgumentException("未找到入驻页面模版"));
    }

    public List<SettleTemplate> findByFlowId(long flowId) {
        List<SettleTemplate> templates = flowDao.findTemplateByFlowId(flowId);
        for (SettleTemplate template : templates) {
            List<String> serviceCodes = templateDao.findServiceCodesByTemplateId(template.getTemplateId());
            SettleFlowTemplateRel settleFlowTemplateRel = flowTemplateRelDao.findAndByFlowIdAndTemplateId(flowId, template.getTemplateId());
            template.setServiceCodes(serviceCodes);
            template.setPageIndex(settleFlowTemplateRel.getPageIndex());
        }
        return templates;
    }

}
