package com.xforceplus.business.tenant.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.tenant.TenantPolicyApi;
import com.xforceplus.api.model.TenantPolicyModel;
import com.xforceplus.business.tenant.service.TenantPolicyService;
import com.xforceplus.entity.TenantPolicy;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.Min;

/**
 * 租户策略.
 *
 * @author feihu.wang
 */
@Api(value = "租户策略相关接口")
@Validated
@Controller
public class TenantPolicyController implements TenantPolicyApi {

    private final TenantPolicyService tenantPolicyService;

    public TenantPolicyController(TenantPolicyService tenantPolicyService) {
        this.tenantPolicyService = tenantPolicyService;
    }

    @ApiOperation(value = "租户策略分页", notes = "租户策略分页")
    @Override
    public ResponseEntity<Page<TenantPolicy>> page(TenantPolicyModel.Request.Query query, Pageable pageable) {
        Page<TenantPolicy> result = tenantPolicyService.page(query, pageable);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value = "租户策略创建", notes = "租户策略创建")
    @Override
    public ResponseEntity<TenantPolicy> create(TenantPolicyModel.Request.Save policy) {
        TenantPolicy result = tenantPolicyService.save(policy);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value = "租户策略更新", notes = "租户策略更新")
    @Override
    public ResponseEntity<TenantPolicy> update(long id, TenantPolicyModel.Request.Update policy) {
        TenantPolicy result = tenantPolicyService.update(policy);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value = "租户策略删除", notes = "租户策略删除")
    @Override
    public ResponseEntity<String> delete(long id) {
        tenantPolicyService.deleteById(id);
        return ResponseEntity.ok("删除成功");
    }

    @ApiOperation(value = "租户策略详情", notes = "租户策略详情")
    @Override
    public ResponseEntity<TenantPolicy> info(long id) {
        TenantPolicy result = tenantPolicyService.findById(id);
        return ResponseEntity.ok(result);
    }
}
