package com.xforceplus.business.tenant.dto;


import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;

@Setter
@Getter
@ToString
public class RoleAccountImportDto extends DataRow {

    @ExcelProperty(value = "操作")
    private String action;

    @ExcelProperty(value = "账号")
    @NotBlank(message = "账号不能为空")
    private String account;

    @ExcelProperty("角色代码")
    @NotBlank(message = "角色代码不能为空")
    private String roleCode;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setAccount(String account) {
        this.account = StringUtils.trim(account);
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = StringUtils.trim(roleCode);
    }
}
