package com.xforceplus.business.tenant.dto;

import com.xforceplus.business.excel.DataRow;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * 用户导出dto.
 *
 * @author feihu.wang
 */
@SuppressWarnings("all")
@Setter
@Getter
public class UserExportDTO extends DataRow implements Serializable {
    private String telPhone;
    private String email;
    private String username;
    private Integer changePasswordFlag;
    private String userName;
    private String userNumber;
    private String userCode;
    private String userPhone;
    private String userWorkTel;
    private String userSex;
    private String userIdCard;
    private String contactAddr;
    private String expiredDate;
    private String sourceType;
    private String status;

    public void setTelPhone(String telPhone) {
        this.telPhone = StringUtils.trim(telPhone);
    }

    public void setEmail(String email) {
        this.email = StringUtils.trim(email);
    }

    public void setUsername(String username) {
        this.username = StringUtils.trim(username);
    }

    public void setUserName(String userName) {
        this.userName = StringUtils.trim(userName);
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = StringUtils.trim(userNumber);
    }

    public void setUserCode(String userCode) {
        this.userCode = StringUtils.trim(userCode);
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = StringUtils.trim(userPhone);
    }

    public void setUserWorkTel(String userWorkTel) {
        this.userWorkTel = StringUtils.trim(userWorkTel);
    }

    public void setUserSex(String userSex) {
        this.userSex = StringUtils.trim(userSex);
    }

    public void setUserIdCard(String userIdCard) {
        this.userIdCard = StringUtils.trim(userIdCard);
    }

    public void setContactAddr(String contactAddr) {
        this.contactAddr = StringUtils.trim(contactAddr);
    }

    public void setExpiredDate(String expiredDate) {
        this.expiredDate = StringUtils.trim(expiredDate);
    }

    public void setSourceType(String sourceType) {
        this.sourceType = StringUtils.trim(sourceType);
    }

    public void setStatus(String status) {
        this.status = StringUtils.trim(status);
    }

    @Override
    @SuppressWarnings("all")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UserExportDTO that = (UserExportDTO) o;

        if (!telPhone.equals(that.telPhone)) {
            return false;
        }
        if (!email.equals(that.email)) {
            return false;
        }
        if (!username.equals(that.username)) {
            return false;
        }
        if (!changePasswordFlag.equals(that.changePasswordFlag)) {
            return false;
        }
        if (!userName.equals(that.userName)) {
            return false;
        }
        if (!userNumber.equals(that.userNumber)) {
            return false;
        }
        if (!userCode.equals(that.userCode)) {
            return false;
        }
        if (!userPhone.equals(that.userPhone)) {
            return false;
        }
        if (!userWorkTel.equals(that.userWorkTel)) {
            return false;
        }
        if (!userSex.equals(that.userSex)) {
            return false;
        }
        if (!userIdCard.equals(that.userIdCard)) {
            return false;
        }
        if (!expiredDate.equals(that.expiredDate)){
            return false;
        }
        return contactAddr.equals(that.contactAddr);

    }

    @Override
    public int hashCode() {
        int result = telPhone.hashCode();
        result = 31 * result + email.hashCode();
        result = 31 * result + username.hashCode();
        result = 31 * result + changePasswordFlag.hashCode();
        result = 31 * result + userName.hashCode();
        result = 31 * result + userNumber.hashCode();
        result = 31 * result + userCode.hashCode();
        result = 31 * result + userPhone.hashCode();
        result = 31 * result + userWorkTel.hashCode();
        result = 31 * result + userSex.hashCode();
        result = 31 * result + userIdCard.hashCode();
        result = 31 * result + contactAddr.hashCode();
        result = 31 * result + expiredDate.hashCode();
        return result;
    }
}