package com.xforceplus.business.tenant.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.business.validator.GenderValidator;
import com.xforceplus.business.validator.SourceTyeValidator;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.util.Date;

/**
 * 用户导出dto.
 *
 * @author feihu.wang
 */
@SuppressWarnings("all")
@Setter
@Getter
public class UserImportDTO extends DataRow implements Serializable {
    @ExcelProperty(value = "操作")
    @NotNull(message = "操作类型不能为空")
    private String action;
    @Pattern(regexp = "^1\\d{10}$", message = "手机号码格式不正确")
    @ExcelProperty(value = "手机账号")
    private String telPhone;
    @Length(max = 200, message = "邮箱长度不能超过{max}")
    @Pattern(regexp = "^[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*(\\.)?@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$", message = "邮箱格式不正确")
    @ExcelProperty(value = "邮箱账号")
    private String email;
    @Length(max = 255, message = "域帐号长度不能超过{max}")
    @ExcelProperty(value = "域账号")
    private String username;

    @ExcelProperty(value = "首次登录修改密码")
    @Range(max = 1, min = 0, message = "首次登录修改密码必须：0-否或1-是")
    private Integer changePasswordFlag;

    //新的设计文档，该字段不是必选项，默认为1，在service或者dao层设置默认值
    @ExcelProperty(value = "是否启用")
    @Range(max = 1, min = 0, message = "是否启用必须：0-否或1-是")
    private Integer status;

    @Length(max = 200, message = "姓名长度不能超过{max}")
    @ExcelProperty(value = "姓名")
    private String userName;

    @Length(max = 200, message = "人员工号长度不能超过{max}")
    @ExcelProperty(value = "工号")
    private String userNumber;

    @Length(max = 200, message = "人员代码长度不能超过{max}")
    @ExcelProperty(value = "人员代码")
    private String userCode;

    @Pattern(regexp = "^1\\d{10}$", message = "手机号码格式不正确")
    @ExcelProperty(value = "手机号")
    private String userPhone;
    @ExcelProperty(value = "办公电话")
    private String userWorkTel;

    @GenderValidator
    @ExcelProperty(value = "性别")
    private String userSex;
    @Pattern(regexp = "(^\\d{17}[0-9Xx]$|\\d{15})", message = "身份证格式不正确")
    @ExcelProperty(value = "身份证号码")
    private String userIdCard;

    @Length(max = 200, message = "联系地址长度不能超过{max}")
    @ExcelProperty(value = "联系地址")
    private String contactAddr;

    //新增用户，需要密码; 修改用户不需要密码；
//    @NotEmpty(message = "密码不能为空")
    @ExcelProperty(value = "密码")
    private String password;

    @ExcelProperty(value = "账号失效日期")
    @DateTimeFormat("yyyy-MM-dd")
    private Date expiredDate;

    @ExcelProperty(value = "来源类型")
    @SourceTyeValidator
    private String sourceType;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setTelPhone(String telPhone) {
        this.telPhone = StringUtils.trim(telPhone);
    }

    public void setEmail(String email) {
        this.email = StringUtils.trim(email);
    }

    public void setUsername(String username) {
        this.username = StringUtils.trim(username);
    }

    public void setUserName(String userName) {
        this.userName = StringUtils.trim(userName);
    }

    public String getUsername() {
        return username;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = StringUtils.trim(userNumber);
    }

    public void setUserCode(String userCode) {
        this.userCode = StringUtils.trim(userCode);
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = StringUtils.trim(userPhone);
    }

    public void setUserWorkTel(String userWorkTel) {
        this.userWorkTel = StringUtils.trim(userWorkTel);
    }

    public void setUserSex(String userSex) {
        this.userSex = StringUtils.trim(userSex);
    }

    public void setUserIdCard(String userIdCard) {
        this.userIdCard = StringUtils.trim(userIdCard);
    }

    public void setContactAddr(String contactAddr) {
        this.contactAddr = StringUtils.trim(contactAddr);
    }

    public void setPassword(String password) {
        this.password = StringUtils.trim(password);
    }

    public void setSourceType(String sourceType) {
        this.sourceType = StringUtils.trim(sourceType);
    }

    @Override
    public String toString() {
        return "UserImportDTO{" +
                "action='" + action + '\'' +
                ", telPhone='" + telPhone + '\'' +
                ", email='" + email + '\'' +
                ", username='" + username + '\'' +
                ", changePasswordFlag=" + changePasswordFlag +
                ", status=" + status +
                ", userName='" + userName + '\'' +
                ", userNumber='" + userNumber + '\'' +
                ", userCode='" + userCode + '\'' +
                ", userPhone='" + userPhone + '\'' +
                ", userWorkTel='" + userWorkTel + '\'' +
                ", userSex='" + userSex + '\'' +
                ", userIdCard='" + userIdCard + '\'' +
                ", contactAddr='" + contactAddr + '\'' +
                ", password='" + password + '\'' +
                ", expireDate='" + expiredDate + '\'' +
                ", sourceType='" + sourceType + '\'' +
                '}';
    }
}