package com.xforceplus.business.tenant.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * .
 *
 * @author feihu.wang
 */
@Getter
@Setter
@ToString
public class UserOrgImportDTO extends DataRow implements Serializable {
    @ExcelProperty(value = "操作")
    private String action;

    @NotEmpty(message = "账号不能为空")
    @ExcelProperty(value = "账号")
    private String username;

    @ExcelProperty(value = "组织代码")
    private String orgCode;

    @ExcelProperty(value = "公司税号")
    private String taxNum;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setUsername(String username) {
        this.username = StringUtils.trim(username);
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = StringUtils.trim(orgCode);
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = StringUtils.trim(taxNum);
    }
}