package com.xforceplus.business.tenant.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * .
 *
 * @author feihu.wang
 */
@Getter
@Setter
@ToString
public class UserRoleImportDTO extends DataRow implements Serializable {
    @ExcelProperty(value = "操作")
    private String action;

    @NotEmpty(message = "账号不能为空")
    @ExcelProperty(value = "账号")
    private String username;

    @NotEmpty(message = "角色代码不能为空")
    @ExcelProperty(value = "角色代码")
    private String roleCode;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setUsername(String username) {
        this.username = StringUtils.trim(username);
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = StringUtils.trim(roleCode);
    }
}