package com.xforceplus.business.tenant.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * .
 *
 * @author feihu.wang
 */
@Getter
@Setter
@ToString
public class UserTagImportDTO extends DataRow implements Serializable {

    @ExcelProperty(value = "操作")
    private String action;

    @NotEmpty(message = "账号不能为空")
    @ExcelProperty(value = "账号")
    private String username;

    @ExcelProperty(value = "发票类型")
    private String invoiceType;
    @ExcelProperty(value = "税控设备唯一码")
    private String printingEquipment;
    @ExcelProperty(value = "税控终端唯一码")
    private String ticketOpeningTerminal;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setUsername(String username) {
        this.username = StringUtils.trim(username);
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = StringUtils.trim(invoiceType);
    }

    public void setPrintingEquipment(String printingEquipment) {
        this.printingEquipment = StringUtils.trim(printingEquipment);
    }

    public void setTicketOpeningTerminal(String ticketOpeningTerminal) {
        this.ticketOpeningTerminal = StringUtils.trim(ticketOpeningTerminal);
    }
}