package com.xforceplus.business.tenant.excel;

import com.alibaba.excel.annotation.format.DateTimeFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author geewit
 */
@Setter
@Getter
public class CompanyExportData {

    @ApiModelProperty(value = "公司id")
    private Long companyId;

    @ApiModelProperty(value = "企业编码")
    private String companyCode;

    @ApiModelProperty(value = "企业名称")
    private String companyName;

    @ApiModelProperty(value = "税号")
    private String taxNum;

    @ApiModelProperty(value = "公司经营所在省份")
    private String locationArea;

    @ApiModelProperty(value = "公司经营所在市区")
    private String locationCity;

    @ApiModelProperty(value = "公司经营详细地址")
    private String locationAddr;

    @ApiModelProperty(value = "公司经营电话")
    private String companyPhone;

    @ApiModelProperty(value = "营业期限开始时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date businessStartTime;

    @DateTimeFormat("yyyy-MM-dd")
    @ApiModelProperty(value = "营业期限结束时间")
    private Date businessEndTime;

    @ApiModelProperty(value = "营业时间是否长期")
    private Integer businessTimeLong;

    @ApiModelProperty(value = "企业经营范围")
    private String businessScope;

    @ApiModelProperty(value = "企业Logo")
    private String companyLogo;

    @ApiModelProperty(value = "营业执照影像")
    private String businessLicense;

    @ApiModelProperty(value = "平台管理人身份", notes = "0:法定代表人, 1:代理人")
    private Integer platManagerStatus;

    @ApiModelProperty(value = "法人归属地")
    private String managerLocation;

    @ApiModelProperty(value = "法人姓名")
    private String managerName;

    @ApiModelProperty(value = "法人证件类型  1-身份证")
    private String managerCardType;

    @ApiModelProperty(value = "法人身份证")
    private String managerIdCard;

    @ApiModelProperty(value = "法人联系方式")
    private String managerPhone;

    @DateTimeFormat("yyyy-MM-dd")
    @ApiModelProperty(value = "法人证件开始时间")
    private Date managerIdCardStartTime;

    @DateTimeFormat("yyyy-MM-dd")
    @ApiModelProperty(value = "法人证件结束时间")
    private Date managerIdCardEndTime;

    @ApiModelProperty(value = "法人身份证长期")
    private Integer managerIdCardTimeLong;

    @ApiModelProperty(value = "法人证件正面照")
    private String managerIdCardFrontPhoto;

    @ApiModelProperty(value = "法人证件背面照")
    private String managerIdCardBackPhoto;

    @ApiModelProperty(value = "开户行名称")
    private String bankName;

    @ApiModelProperty(value = "开户银行支行名称")
    private String bankBranchName;

    @ApiModelProperty(value = "对公银行账户")
    private String bankNo;

    @ApiModelProperty(value = "银行所在省份")
    private String bankArea;

    @ApiModelProperty(value = "银行所在市区")
    private String bankCity;

    @ApiModelProperty(value = "注销/启用原因")
    private String operateReason;

    @ApiModelProperty(value = "传统认证管理状态", notes = "1:开启；0:关闭")
    private Integer traditionAuthenFlag;

    @ApiModelProperty(value = "查验服务状态", notes = "1:开启；0:关闭")
    private Integer inspectionServiceFlag;

    @ApiModelProperty(value = "极速查验通道状态", notes = "1:开启；0:关闭")
    private Integer speedInspectionChannelFlag;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    private Integer status;

    @ApiModelProperty(value = "增值税普通发票限额")
    private BigDecimal cquota;

    @ApiModelProperty(value = "增值税专用发票限额")
    private BigDecimal squota;

    @ApiModelProperty(value = "增值税电子普通发票限额")
    private BigDecimal ceQuota;

    @ApiModelProperty(value = "增值税普通发票-卷票限额")
    private BigDecimal juQuota;

    @ApiModelProperty(value = "增值税电子专票限额")
    private BigDecimal seQuota;

    @ApiModelProperty(value = "机动车发票限额")
    private BigDecimal vehicleLimit;

    @ApiModelProperty(value = "企业注册省份")
    private String registLocationArea;

    @ApiModelProperty(value = "企业注册城市")
    private String registLocationCity;

    @ApiModelProperty(value = "企业注册详细地址")
    private String registLocationAddr;

    @ApiModelProperty(value = "纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人")
    private Integer taxpayerQualificationType;

    @ApiModelProperty(value = "纳税人资质证书")
    private String taxpayerQualification;

    @ApiModelProperty(value = "代理人姓名")
    private String proxyManagerName;

    @ApiModelProperty(value = "代理人证据类型  1-身份证")
    private String proxyManagerCardType;

    @ApiModelProperty(value = "代理人身份证")
    private String proxyManagerIdCard;

    @ApiModelProperty(value = "代理人联系方式")
    private String proxyManagerPhone;

    @DateTimeFormat("yyyy-MM-dd")
    @ApiModelProperty(value = "代理人证件开始时间")
    private Date proxyManagerIdCardStartTime;

    @DateTimeFormat("yyyy-MM-dd")
    @ApiModelProperty(value = "代理人证件结束时间")
    private Date proxyManagerIdCardEndTime;

    @ApiModelProperty(value = "代理人身份证长期")
    private Integer proxyManagerIdCardTimeLong;

    @ApiModelProperty(value = "代理人证件正面照")
    private String proxyManagerIdCardFrontPhoto;

    @ApiModelProperty(value = "代理人证件背面照")
    private String proxyManagerIdCardBackPhoto;

    public void setCompanyCode(String companyCode) {
        this.companyCode = StringUtils.trim(companyCode);
    }

    public void setCompanyName(String companyName) {
        this.companyName = StringUtils.trim(companyName);
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = StringUtils.trim(taxNum);
    }

    public void setLocationArea(String locationArea) {
        this.locationArea = StringUtils.trim(locationArea);
    }

    public void setLocationCity(String locationCity) {
        this.locationCity = StringUtils.trim(locationCity);
    }

    public void setLocationAddr(String locationAddr) {
        this.locationAddr = StringUtils.trim(locationAddr);
    }

    public void setCompanyPhone(String companyPhone) {
        this.companyPhone = StringUtils.trim(companyPhone);
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = StringUtils.trim(businessScope);
    }

    public void setCompanyLogo(String companyLogo) {
        this.companyLogo = StringUtils.trim(companyLogo);
    }

    public void setBusinessLicense(String businessLicense) {
        this.businessLicense = StringUtils.trim(businessLicense);
    }

    public void setManagerLocation(String managerLocation) {
        this.managerLocation = StringUtils.trim(managerLocation);
    }

    public void setManagerName(String managerName) {
        this.managerName = StringUtils.trim(managerName);
    }

    public void setManagerCardType(String managerCardType) {
        this.managerCardType = StringUtils.trim(managerCardType);
    }

    public void setManagerIdCard(String managerIdCard) {
        this.managerIdCard = StringUtils.trim(managerIdCard);
    }

    public void setManagerPhone(String managerPhone) {
        this.managerPhone = StringUtils.trim(managerPhone);
    }

    public void setManagerIdCardFrontPhoto(String managerIdCardFrontPhoto) {
        this.managerIdCardFrontPhoto = StringUtils.trim(managerIdCardFrontPhoto);
    }

    public void setManagerIdCardBackPhoto(String managerIdCardBackPhoto) {
        this.managerIdCardBackPhoto = StringUtils.trim(managerIdCardBackPhoto);
    }

    public void setBankName(String bankName) {
        this.bankName = StringUtils.trim(bankName);
    }

    public void setBankBranchName(String bankBranchName) {
        this.bankBranchName = StringUtils.trim(bankBranchName);
    }

    public void setBankNo(String bankNo) {
        this.bankNo = StringUtils.trim(bankNo);
    }

    public void setBankArea(String bankArea) {
        this.bankArea = StringUtils.trim(bankArea);
    }

    public void setBankCity(String bankCity) {
        this.bankCity = StringUtils.trim(bankCity);
    }

    public void setOperateReason(String operateReason) {
        this.operateReason = StringUtils.trim(operateReason);
    }

    public void setRegistLocationArea(String registLocationArea) {
        this.registLocationArea = StringUtils.trim(registLocationArea);
    }

    public void setRegistLocationCity(String registLocationCity) {
        this.registLocationCity = StringUtils.trim(registLocationCity);
    }

    public void setRegistLocationAddr(String registLocationAddr) {
        this.registLocationAddr = StringUtils.trim(registLocationAddr);
    }

    public void setTaxpayerQualification(String taxpayerQualification) {
        this.taxpayerQualification = StringUtils.trim(taxpayerQualification);
    }

    public void setProxyManagerName(String proxyManagerName) {
        this.proxyManagerName = StringUtils.trim(proxyManagerName);
    }

    public void setProxyManagerCardType(String proxyManagerCardType) {
        this.proxyManagerCardType = StringUtils.trim(proxyManagerCardType);
    }

    public void setProxyManagerIdCard(String proxyManagerIdCard) {
        this.proxyManagerIdCard = StringUtils.trim(proxyManagerIdCard);
    }

    public void setProxyManagerPhone(String proxyManagerPhone) {
        this.proxyManagerPhone = StringUtils.trim(proxyManagerPhone);
    }

    public void setProxyManagerIdCardFrontPhoto(String proxyManagerIdCardFrontPhoto) {
        this.proxyManagerIdCardFrontPhoto = StringUtils.trim(proxyManagerIdCardFrontPhoto);
    }

    public void setProxyManagerIdCardBackPhoto(String proxyManagerIdCardBackPhoto) {
        this.proxyManagerIdCardBackPhoto = StringUtils.trim(proxyManagerIdCardBackPhoto);
    }
}
