package com.xforceplus.business.tenant.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * 组织批量导出Excel类
 *
 * @author geewit
 * @since 2020-09-25
 */
@Setter
@Getter
@SuppressWarnings("all")
public abstract class ExcelImportData extends DataRow implements Serializable {
    private final static String ACTION_NEW = "新建";
    /**
     * 操作
     */
    @ExcelProperty(value = "操作")
    protected String action;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    /**
     * 是否新增
     */
    public Boolean isNew() {
        if (this.action == null) {
            return null;
        }
        if (ACTION_NEW.equals(this.action)) {
            return true;
        }
        return false;
    }
}
