package com.xforceplus.business.tenant.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.xforceplus.business.validator.ValidateCompany;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyApply;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 组织批量导出Excel类
 *
 * @author geewit
 * @since 2020-09-25
 */
@ValidateCompany(actions = {"新建", "修改"})
@Setter
@Getter
@ToString
public class OrgCompanyExcelImportData extends ExcelImportData {

    /**
     * 租户ID
     */
    @ExcelIgnore
    private Long tenantId;

    /**
     * 公司实体
     */
    @ExcelIgnore
    private Company company;

    /**
     * 公司申请实体
     */
    @ExcelIgnore
    private CompanyApply companyApply;

    /**
     * 组织ID
     */
    @ExcelIgnore
    private Long orgId;

    /**
     * 税号
     */
    @NotEmpty(message = "统一社会信用代码不能为空")
    @Size(min = 1, max = 60, message = "统一社会信用代码长度介于1~50个字符之间")
    @ExcelProperty("统一社会信用代码")
    private String taxNum;
    /**
     * 企业名称
     */
    @ExcelProperty("公司名称")
    @Size(min = 1, max = 60, message = "公司名称长度介于1~50个字符之间")
    private String companyName;
    /**
     * 企业注册省份
     */
    @ExcelProperty("企业注册省份")
    private String registLocationArea;
    /**
     * 企业注册城市
     */
    @ExcelProperty("企业注册城市")
    private String registLocationCity;
    /**
     * 企业注册详细地址
     */
    @ExcelProperty("公司注册详细地址")
    private String registLocationAddr;
    /**
     * 公司经营所在省份
     */
    @ExcelProperty("公司经营所在省份")
    private String locationArea;
    /**
     * 公司经营所在市区
     */
    @ExcelProperty("公司经营所在市区")
    private String locationCity;
    /**
     * 公司经营详细地址
     */
    @ExcelProperty("公司经营详细地址")
    private String locationAddr;
    /**
     * 公司联系电话
     */
    @ExcelProperty("公司联系电话")
    private String companyPhone;
    /**
     * 营业期限开始时间
     */
    @ExcelProperty("营业期限开始时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date businessStartTime;
    /**
     * 营业期限结束时间
     */
    @ExcelProperty("营业期限结束时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date businessEndTime;
    /**
     * 营业时间是否长期
     */
    @ExcelProperty("营业时间是否长期")
    private Integer businessTimeLong;
    /**
     * 企业经营范围
     */
    @ExcelProperty("企业经营范围")
    private String businessScope;
    /**
     * 平台管理人身份,0:法定代表人, 1:代理人
     */
    @ExcelProperty("平台管理人身份")
    private Integer platManagerStatus;
    /**
     * 法人归属地
     */
    @ExcelProperty("法人归属地")
    private String managerLocation;
    /**
     * 法人姓名
     */
    @ExcelProperty("法人姓名")
    private String managerName;
    /**
     * 法人证件开始时间
     */
    @ExcelProperty("法人证件开始时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date managerIdCardStartTime;
    /**
     * 法人证件结束时间
     */
    @ExcelProperty("法人证件结束时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date managerIdCardEndTime;
    /**
     * 法人身份证长期
     */
    @ExcelProperty("法人身份证长期")
    private Integer managerIdCardTimeLong;
    /**
     * 法人证件类型  1-身份证
     */
    @ExcelProperty("法人证件类型")
    private String managerCardType;
    /**
     * 法人身份证
     */
    @ExcelProperty("法人身份证")
    private String managerIdCard;
    /**
     * 法人联系方式
     */
    @ExcelProperty("法人联系方式")
    private String managerPhone;
    /**
     * 代理人姓名
     */
    @ExcelProperty("代理人姓名")
    private String proxyManagerName;
    /**
     * 代理人证件开始时间
     */
    @ExcelProperty("代理人证件开始时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date proxyManagerIdCardStartTime;
    /**
     * 代理人证件结束时间
     */
    @ExcelProperty("代理人证件结束时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date proxyManagerIdCardEndTime;
    /**
     * 代理人身份证长期
     */
    @ExcelProperty("代理人身份证长期")
    private Integer proxyManagerIdCardTimeLong;
    /**
     * 代理人证据类型  1-身份证
     */
    @ExcelProperty("代理人证据类型")
    private String proxyManagerCardType;
    /**
     * 代理人身份证
     */
    @ExcelProperty("代理人身份证")
    private String proxyManagerIdCard;
    /**
     * 代理人联系方式
     */
    @ExcelProperty("代理人联系方式")
    private String proxyManagerPhone;
    /**
     * 开户银行名称
     */
    @ExcelProperty("开户银行名称")
    private String bankName;
    /**
     * 对公银行账户
     */
    @ExcelProperty("对公银行账户")
    private String bankNo;
    /**
     * 纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人
     */
    @ExcelProperty("纳税人资质类型")
    private Integer taxpayerQualificationType;
    /**
     * 增值税普通发票限额
     */
    @ExcelProperty("增值税普通发票限额")
    private BigDecimal cquota;
    /**
     * 增值税专用发票限额
     */
    @ExcelProperty("增值税专用发票限额")
    private BigDecimal squota;
    /**
     * 增值税电子普通发票限额
     */
    @ExcelProperty("增值税电子普通发票限额")
    private BigDecimal ceQuota;
    /**
     * 增值税普通发票-卷票限额
     */
    @ExcelProperty("增值税普通发票-卷票限额")
    private BigDecimal juQuota;
    /**
     * 增值税电子专票限额
     */
    @ExcelProperty("增值税电子专票限额")
    private BigDecimal seQuota;

    /**
     * 机动车发票限额
     */
    @ExcelProperty("机动车发票限额")
    private BigDecimal vehicleLimit;

    public void setTaxNum(String taxNum) {
        this.taxNum = StringUtils.trim(taxNum);
    }

    public void setCompanyName(String companyName) {
        this.companyName = StringUtils.trim(companyName);
    }

    public void setRegistLocationArea(String registLocationArea) {
        this.registLocationArea = StringUtils.trim(registLocationArea);
    }

    public void setRegistLocationCity(String registLocationCity) {
        this.registLocationCity = StringUtils.trim(registLocationCity);
    }

    public void setRegistLocationAddr(String registLocationAddr) {
        this.registLocationAddr = StringUtils.trim(registLocationAddr);
    }

    public void setLocationArea(String locationArea) {
        this.locationArea = StringUtils.trim(locationArea);
    }

    public void setLocationCity(String locationCity) {
        this.locationCity = StringUtils.trim(locationCity);
    }

    public void setLocationAddr(String locationAddr) {
        this.locationAddr = StringUtils.trim(locationAddr);
    }

    public void setCompanyPhone(String companyPhone) {
        this.companyPhone = StringUtils.trim(companyPhone);
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = StringUtils.trim(businessScope);
    }

    public void setManagerLocation(String managerLocation) {
        this.managerLocation = StringUtils.trim(managerLocation);
    }

    public void setManagerName(String managerName) {
        this.managerName = StringUtils.trim(managerName);
    }

    public void setManagerCardType(String managerCardType) {
        this.managerCardType = StringUtils.trim(managerCardType);
    }

    public void setManagerIdCard(String managerIdCard) {
        this.managerIdCard = StringUtils.trim(managerIdCard);
    }

    public void setManagerPhone(String managerPhone) {
        this.managerPhone = StringUtils.trim(managerPhone);
    }

    public void setProxyManagerName(String proxyManagerName) {
        this.proxyManagerName = StringUtils.trim(proxyManagerName);
    }

    public void setProxyManagerCardType(String proxyManagerCardType) {
        this.proxyManagerCardType = StringUtils.trim(proxyManagerCardType);
    }

    public void setProxyManagerIdCard(String proxyManagerIdCard) {
        this.proxyManagerIdCard = StringUtils.trim(proxyManagerIdCard);
    }

    public void setProxyManagerPhone(String proxyManagerPhone) {
        this.proxyManagerPhone = StringUtils.trim(proxyManagerPhone);
    }

    public void setBankName(String bankName) {
        this.bankName = StringUtils.trim(bankName);
    }

    public void setBankNo(String bankNo) {
        this.bankNo = StringUtils.trim(bankNo);
    }
}
