package com.xforceplus.business.tenant.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.validator.ValidateOrg;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyApply;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.tenant.security.core.domain.OrgType;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;

/**
 * 组织批量导出Excel类
 *
 * @author geewit
 * @since 2020-09-25
 */
@ValidateOrg(actions = {"新建", "修改"})
@Setter
@Getter
@ToString
public class OrgExcelImportData extends ExcelImportData {

    /**
     * 租户ID
     */
    @ExcelIgnore
    private Long tenantId;

    /**
     * 组织实体
     */
    private OrgStruct org;

    /**
     * 公司实体
     */
    @ExcelIgnore
    private Company company;

    /**
     * 公司申请实体
     */
    @ExcelIgnore
    private CompanyApply companyApply;

    /**
     * 组织代码
     */
    @ExcelProperty("组织代码")
    @NotBlank(message = "组织代码不能为空")
    private String orgCode;
    /**
     * 组织代码
     */
    @ExcelProperty("上级组织代码")
    private String parentCode;

    /**
     * 组织名称
     */
    @ExcelProperty("组织名称")
    private String orgName;

    @ExcelProperty("组织备注")
    private String orgDesc;

    @ExcelProperty("自定义类型")
    private String orgBizType;

    @ExcelProperty("组织状态")
    @Range(min = 0, max = 1, message = "组织状态只能为0或者1")
    private Integer status;

    @ExcelIgnore
    private OrgType orgType;

    @ExcelProperty("统一社会信用代码")
    private String taxNum;

    @ExcelProperty("上级组织的统一社会信用代码")
    private String parentTaxNumber;

    @ExcelProperty("终端鉴权")
    private Integer terminalAuth;

    public void setOrgCode(String orgCode) {
        this.orgCode = StringUtils.trim(orgCode);
    }

    public void setParentCode(String parentCode) {
        this.parentCode = StringUtils.trim(parentCode);
    }

    public void setOrgName(String orgName) {
        this.orgName = StringUtils.trim(orgName);
    }

    public void setOrgDesc(String orgDesc) {
        this.orgDesc = StringUtils.trim(orgDesc);
    }

    public void setOrgBizType(String orgBizType) {
        this.orgBizType = StringUtils.trim(orgBizType);
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = StringUtils.trim(taxNum);
    }

    public void setParentTaxNumber(String parentTaxNumber) {
        this.parentTaxNumber = StringUtils.trim(parentTaxNumber);
    }
}
