package com.xforceplus.business.tenant.excel;

import com.xforceplus.business.excel.ExcelSheet;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * <p>
 * Title: 服务配置Excel定义
 * </p>
 * <p>
 * Description: 服务配置Excel定义
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author geewit
 * @since V1.0
 */
public class OrgExportExcel {
    public OrgExportExcel() {
    }

    /**
     * 默认Excel文件{@value}
     */
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "template/org/export.xlsx";
    /**
     * 默认排序字段{@value}
     */
    public static final String SORT_FIELD = "createTime";
    /**
     * Sheet1名
     */
    public static final String SHEET_NAME_1 = "公司";
    /**
     * Sheet2名
     */
    public static final String SHEET_NAME_2 = "组织";
    /**
     * 过滤的字段
     */
    public static final int EXPORT_BATCH_SIZE = 1000;

    public static final String BUSINESS_NAME = "组织列表导出";

    /**
     * 服务醘
     */
    private static final List<ExcelSheet> SHEETS = Stream.of(
            new ExcelSheet(0, SHEET_NAME_1),
            new ExcelSheet(1, SHEET_NAME_2)
    ).collect(Collectors.toList());


    /**
     * 获取ExcelSheet
     *
     * @return List<ExcelSheet> ExcelSheet列表
     */
    public static List<ExcelSheet> getSheets() {
        return SHEETS;
    }
}
